/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.jboss.cache.CacheException;
import org.jboss.cache.aop.PojoCacheMBean;
import org.jboss.metadata.WebMetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.web.tomcat.service.session.AttributeBasedClusteredSession;
import org.jboss.web.tomcat.service.session.BatchReplicationClusteredSessionValve;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.ClusteredSessionValve;
import org.jboss.web.tomcat.service.session.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.FieldBasedClusteredSession;
import org.jboss.web.tomcat.service.session.InstantSnapshotManager;
import org.jboss.web.tomcat.service.session.IntervalSnapshotManager;
import org.jboss.web.tomcat.service.session.JBossCacheCluster;
import org.jboss.web.tomcat.service.session.JBossCacheClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheManagerMBean;
import org.jboss.web.tomcat.service.session.JBossCacheService;
import org.jboss.web.tomcat.service.session.JBossManager;
import org.jboss.web.tomcat.service.session.JvmRouteValve;
import org.jboss.web.tomcat.service.session.SessionBasedClusteredSession;
import org.jboss.web.tomcat.service.session.SessionReplicationContext;
import org.jboss.web.tomcat.service.session.SnapshotManager;
import org.jboss.web.tomcat.service.session.Util;

public class JBossCacheManager
extends JBossManager
implements JBossCacheManagerMBean {
    static final String info_ = "JBossCacheManager/1.0";
    protected TransactionManager tm;
    private JBossCacheService proxy_;
    private Map unloadedSessions_ = new ConcurrentHashMap();
    private String cacheObjectNameString_ = "jboss.cache:service=TomcatClusteringCache";
    protected boolean useJK_ = false;
    private boolean embedded_ = false;
    private MBeanServer mserver_ = null;
    private String snapshotMode_ = null;
    private int snapshotInterval_ = 0;
    private String replTriggerString_ = null;
    private String replGranularityString_ = null;
    private Boolean replicationFieldBatchMode_;
    private ClassLoader tcl_;
    private SnapshotManager snapshotManager_;
    private boolean trace;
    private int maxUnreplicatedInterval_ = 60;

    public JBossCacheManager() {
    }

    public JBossCacheManager(PojoCacheMBean pojoCache) {
        this.proxy_ = new JBossCacheService(pojoCache);
    }

    public void init(String name, WebMetaData webMetaData, boolean useJK, boolean useLocalCache) throws ClusteringNotSupportedException {
        super.init(name, webMetaData, useJK, useLocalCache);
        this.useJK_ = useJK;
        this.replicationFieldBatchMode_ = webMetaData.getReplicationFieldBatchMode() ? Boolean.TRUE : Boolean.FALSE;
        Integer maxUnrep = webMetaData.getMaxUnreplicatedInterval();
        if (maxUnrep != null) {
            this.maxUnreplicatedInterval_ = maxUnrep;
        }
        if (this.proxy_ == null) {
            this.proxy_ = new JBossCacheService(this.cacheObjectNameString_);
        }
        this.validateFieldMarshalling();
        this.embedded_ = true;
    }

    public JBossCacheService getCacheService() {
        return this.proxy_;
    }

    public String getCacheObjectNameString() {
        return this.cacheObjectNameString_;
    }

    public void setCacheObjectNameString(String treeCacheObjectName) {
        this.cacheObjectNameString_ = treeCacheObjectName;
    }

    public String getSnapshotMode() {
        return this.snapshotMode_;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode_ = snapshotMode;
    }

    public int getSnapshotInterval() {
        return this.snapshotInterval_;
    }

    public void setSnapshotInterval(int snapshotInterval) {
        this.snapshotInterval_ = snapshotInterval;
    }

    public boolean getUseJK() {
        return this.useJK_;
    }

    public void setUseJK(boolean useJK) {
        this.useJK_ = useJK;
    }

    public int getReplicationGranularity() {
        return this.replicationGranularity_;
    }

    public String getReplicationGranularityString() {
        if (this.started_ && this.replGranularityString_ == null) {
            switch (this.replicationGranularity_) {
                case 1: {
                    this.replGranularityString_ = "ATTRIBUTE";
                    break;
                }
                case 0: {
                    this.replGranularityString_ = "SESSION";
                    break;
                }
                case 2: {
                    this.replGranularityString_ = "FIELD";
                }
            }
        }
        return this.replGranularityString_;
    }

    public void setReplicationGranularityString(String granularity) {
        this.replGranularityString_ = granularity;
    }

    public String getReplicationTriggerString() {
        if (this.started_ && this.replTriggerString_ == null) {
            switch (this.invalidateSessionPolicy_) {
                case 3: {
                    this.replTriggerString_ = "SET";
                    break;
                }
                case 1: {
                    this.replTriggerString_ = "SET_AND_GET";
                    break;
                }
                case 2: {
                    this.replTriggerString_ = "SET_AND_NON_PRIMITIVE_GET";
                }
            }
        }
        return this.replTriggerString_;
    }

    public void setReplicationTriggerString(String trigger) {
        this.replTriggerString_ = trigger;
    }

    public Boolean isReplicationFieldBatchMode() {
        return this.replicationFieldBatchMode_;
    }

    public void setReplicationFieldBatchMode(boolean replicationFieldBatchMode) {
        this.replicationFieldBatchMode_ = replicationFieldBatchMode;
    }

    public void setUseLocalCache(boolean useLocalCache) {
        this.useLocalCache_ = useLocalCache;
    }

    public int getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval_;
    }

    public void setMaxUnreplicatedInterval(int maxUnreplicatedInterval) {
        this.maxUnreplicatedInterval_ = maxUnreplicatedInterval;
    }

    public void expireSession(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session != null) {
            session.expire();
        }
    }

    public String getLastAccessedTime(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session == null) {
            this.log_.debug((Object)("getLastAccessedTime(): Session " + sessionId + " not found"));
            return "";
        }
        return new Date(session.getLastAccessedTime()).toString();
    }

    public Object getSessionAttribute(String sessionId, String key) {
        ClusteredSession session = (ClusteredSession)this.findSession(sessionId);
        return session == null ? null : session.getAttribute(key);
    }

    public String getSessionAttributeString(String sessionId, String key) {
        Object attr = this.getSessionAttribute(sessionId, key);
        return attr == null ? null : attr.toString();
    }

    public String listLocalSessionIds() {
        return this.reportSessionIds(this.sessions_.keySet());
    }

    public String listSessionIds() {
        HashSet ids = new HashSet(this.sessions_.keySet());
        ids.addAll(this.unloadedSessions_.keySet());
        return this.reportSessionIds(ids);
    }

    private String reportSessionIds(Set ids) {
        StringBuffer sb = new StringBuffer();
        boolean added = false;
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            if (added) {
                sb.append(',');
            } else {
                added = true;
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public void start() throws LifecycleException {
        if (this.embedded_) {
            this.startEmbedded();
        } else {
            this.startUnembedded();
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started_) {
            throw new IllegalStateException("Manager not started");
        }
        this.log_.debug((Object)"Stopping");
        this.resetStats();
        this.lifecycle_.fireLifecycleEvent("before_stop", (Object)this);
        this.clearSessions();
        this.tcl_ = null;
        this.proxy_.stop();
        this.tm = null;
        this.snapshotManager_.stop();
        this.started_ = false;
        this.lifecycle_.fireLifecycleEvent("after_stop", (Object)this);
        try {
            this.unregisterMBeans();
        }
        catch (Exception e) {
            this.log_.error((Object)"Could not unregister ManagerMBean from MBeanServer", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearSessions() {
        ClusteredSession[] sessions = this.findLocalSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Object var9_11;
            ClusteredSession ses = sessions[i];
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("clearSessions(): clear session by expiring: " + ses));
            }
            boolean notify = true;
            boolean localCall = true;
            boolean localOnly = true;
            try {
                try {
                    ses.expire(notify, localCall, localOnly);
                }
                catch (Throwable t) {
                    this.log_.warn((Object)("clearSessions(): Caught exception expiring session " + ses.getIdInternal()), t);
                    var9_11 = null;
                    ses.recycle();
                    continue;
                }
                var9_11 = null;
                ses.recycle();
                continue;
            }
            catch (Throwable throwable) {
                var9_11 = null;
                ses.recycle();
                throw throwable;
            }
        }
        HashMap unloaded = new HashMap(this.unloadedSessions_);
        Set keys = unloaded.keySet();
        for (String realId : keys) {
            this.proxy_.removeSessionLocal(realId);
            this.unloadedSessions_.remove(realId);
        }
    }

    public Session createSession() {
        return this.createSession(null);
    }

    public Session createSession(String sessionId) {
        if (this.maxActive_ != -1 && this.activeCounter_ >= this.maxActive_) {
            ++this.rejectedCounter_;
            String msgEnd = sessionId == null ? "" : " id " + sessionId;
            throw new IllegalStateException("JBossCacheManager.add(): number of active sessions exceeds the maximum limit: " + this.maxActive_ + " when trying to add session" + msgEnd);
        }
        ClusteredSession session = this.createEmptyClusteredSession();
        session.setNew(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval_);
        session.setValid(true);
        if (sessionId == null) {
            sessionId = this.getNextId();
            if (this.useJK_) {
                if (this.log_.isDebugEnabled()) {
                    this.log_.debug((Object)("createSession(): useJK is true. Will append JvmRoute: " + this.getJvmRoute()));
                }
                sessionId = sessionId + "." + this.getJvmRoute();
            }
        }
        session.setId(sessionId);
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("Created a ClusteredSession with id: " + sessionId));
        }
        ++this.createdCounter_;
        SessionReplicationContext.bindSession(session, this.snapshotManager_);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeSession(Session baseSession) {
        boolean stored = false;
        if (baseSession != null && this.started_) {
            ClusteredSession session;
            ClusteredSession clusteredSession = session = (ClusteredSession)baseSession;
            synchronized (clusteredSession) {
                if (this.trace) {
                    this.log_.trace((Object)("check to see if needs to store and replicate session with id " + session.getIdInternal()));
                }
                if (session.isValid() && (session.isSessionDirty() || session.getExceedsMaxUnreplicatedInterval())) {
                    String realId = session.getRealId();
                    long begin = System.currentTimeMillis();
                    session.passivate();
                    long elapsed = System.currentTimeMillis() - begin;
                    this.stats_.updatePassivationStats(realId, elapsed);
                    begin = System.currentTimeMillis();
                    this.processSessionRepl(session);
                    elapsed = System.currentTimeMillis() - begin;
                    stored = true;
                    this.stats_.updateReplicationStats(realId, elapsed);
                }
            }
        }
        return stored;
    }

    public void add(Session session) {
        if (session == null) {
            return;
        }
        if (!(session instanceof ClusteredSession)) {
            throw new IllegalArgumentException("You can only add instances of type ClusteredSession to this Manager. Session class name: " + session.getClass().getName());
        }
        this.add((ClusteredSession)session, false);
    }

    private void add(ClusteredSession session, boolean replicate) {
        if (!session.isValid()) {
            this.log_.error((Object)("Cannot add session with id=" + session.getIdInternal() + " because it is invalid"));
            return;
        }
        String realId = session.getRealId();
        ClusteredSession existing = this.sessions_.put(realId, session);
        this.unloadedSessions_.remove(realId);
        if (!session.equals(existing)) {
            if (replicate) {
                this.storeSession((Session)session);
            }
            ++this.activeCounter_;
            if (this.activeCounter_ > this.maxActiveCounter_) {
                ++this.maxActiveCounter_;
            }
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("Session with id=" + session.getIdInternal() + " added. " + "Current active sessions " + this.activeCounter_));
            }
        }
    }

    public Session createEmptySession() {
        return this.createEmptyClusteredSession();
    }

    private ClusteredSession createEmptyClusteredSession() {
        this.log_.debug((Object)"Creating an empty ClusteredSession");
        JBossCacheClusteredSession session = null;
        switch (this.replicationGranularity_) {
            case 1: {
                session = new AttributeBasedClusteredSession(this);
                break;
            }
            case 2: {
                session = new FieldBasedClusteredSession(this);
                break;
            }
            default: {
                session = new SessionBasedClusteredSession(this);
            }
        }
        return session;
    }

    public Session findSession(String id) {
        String realId = this.getRealId(id);
        ClusteredSession session = this.findLocalSession(realId);
        if (session == null && !SessionReplicationContext.isSessionBoundAndExpired(realId, this.snapshotManager_)) {
            if (this.trace) {
                this.log_.trace((Object)("Checking for session " + realId + " in the distributed cache"));
            }
            if ((session = this.loadSession(realId)) != null) {
                this.add((Session)session);
            }
        } else if (session != null && session.isOutdated()) {
            if (this.trace) {
                this.log_.trace((Object)("Updating session " + realId + " from the distributed cache"));
            }
            this.loadSession(realId);
        }
        if (session != null) {
            SessionReplicationContext.bindSession(session, this.snapshotManager_);
        }
        return session;
    }

    public Session[] findSessions() {
        if (this.unloadedSessions_.size() > 0) {
            HashSet ids = new HashSet(this.unloadedSessions_.keySet());
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("findSessions: loading sessions from distributed cache: " + ids));
            }
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                this.loadSession((String)it.next());
            }
        }
        return this.findLocalSessions();
    }

    public ClusteredSession[] findLocalSessions() {
        Collection coll = this.sessions_.values();
        ClusteredSession[] sess = new ClusteredSession[coll.size()];
        sess = coll.toArray(sess);
        return sess;
    }

    public ClusteredSession findLocalSession(String realId) {
        return (ClusteredSession)this.sessions_.get(realId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) {
        ClusteredSession clusterSess;
        ClusteredSession clusteredSession = clusterSess = (ClusteredSession)session;
        synchronized (clusteredSession) {
            String realId = clusterSess.getRealId();
            if (realId == null) {
                return;
            }
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("Removing session from store with id: " + realId));
            }
            try {
                SessionReplicationContext.startCacheActivity();
                clusterSess.removeMyself();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SessionReplicationContext.finishCacheActivity();
                SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
                this.sessions_.remove(realId);
                this.stats_.removeStats(realId);
                --this.activeCounter_;
                throw throwable;
            }
            SessionReplicationContext.finishCacheActivity();
            SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
            this.sessions_.remove(realId);
            this.stats_.removeStats(realId);
            --this.activeCounter_;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocal(Session session) {
        ClusteredSession clusterSess;
        ClusteredSession clusteredSession = clusterSess = (ClusteredSession)session;
        synchronized (clusteredSession) {
            String realId = clusterSess.getRealId();
            if (realId == null) {
                return;
            }
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("Removing session from local store with id: " + realId));
            }
            try {
                SessionReplicationContext.startCacheActivity();
                clusterSess.removeMyselfLocal();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SessionReplicationContext.finishCacheActivity();
                SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
                this.sessions_.remove(realId);
                this.stats_.removeStats(realId);
                ++this.expiredCounter_;
                --this.activeCounter_;
                throw throwable;
            }
            SessionReplicationContext.finishCacheActivity();
            SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
            this.sessions_.remove(realId);
            this.stats_.removeStats(realId);
            ++this.expiredCounter_;
            --this.activeCounter_;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ClusteredSession loadSession(String realId) {
        if (realId == null) {
            return null;
        }
        long begin = System.currentTimeMillis();
        boolean mustAdd = false;
        ClusteredSession session = (ClusteredSession)this.sessions_.get(realId);
        if (session == null) {
            mustAdd = true;
            session = this.createEmptyClusteredSession();
        }
        ClusteredSession clusteredSession = session;
        synchronized (clusteredSession) {
            boolean doTx = false;
            try {
                try {
                    if (this.tm.getTransaction() == null) {
                        doTx = true;
                    }
                    if (doTx) {
                        this.tm.begin();
                    }
                    SessionReplicationContext.startCacheActivity();
                    session = this.proxy_.loadSession(realId, session);
                }
                catch (Exception ex) {
                    try {
                        this.tm.setRollbackOnly();
                    }
                    catch (Exception exn) {
                        this.log_.error((Object)"Problem rolling back session mgmt transaction", (Throwable)exn);
                    }
                    if (!(ex instanceof RuntimeException)) throw new RuntimeException("Failed to load session " + realId, ex);
                    throw (RuntimeException)ex;
                }
                Object var11_7 = null;
                try {
                    if (doTx) {
                        this.endTransaction(realId);
                    }
                    Object var13_9 = null;
                    SessionReplicationContext.finishCacheActivity();
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    SessionReplicationContext.finishCacheActivity();
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                try {}
                catch (Throwable throwable2) {
                    Object var13_12 = null;
                    SessionReplicationContext.finishCacheActivity();
                    throw throwable2;
                }
                if (doTx) {
                    this.endTransaction(realId);
                }
                Object var13_11 = null;
                SessionReplicationContext.finishCacheActivity();
                throw throwable;
            }
            if (session != null) {
                session.initAfterLoad(this);
                if (mustAdd) {
                    this.add(session, false);
                }
                long elapsed = System.currentTimeMillis() - begin;
                this.stats_.updateLoadStats(realId, elapsed);
                if (!this.log_.isDebugEnabled()) return session;
                this.log_.debug((Object)("loadSession(): id= " + realId + ", session=" + session));
            } else {
                if (!this.log_.isDebugEnabled()) return session;
                this.log_.debug((Object)("loadSession(): session " + realId + " not found in distributed cache"));
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processSessionRepl(ClusteredSession session) {
        boolean notSession = this.replicationGranularity_ != 0;
        boolean doTx = false;
        try {
            try {
                if (notSession && this.tm.getTransaction() == null) {
                    doTx = true;
                }
                if (doTx) {
                    this.tm.begin();
                }
                SessionReplicationContext.startCacheActivity();
                session.processSessionRepl();
            }
            catch (Exception ex) {
                if (this.log_.isDebugEnabled()) {
                    this.log_.debug((Object)"processSessionRepl(): failed with exception", (Throwable)ex);
                }
                try {
                    if (notSession) {
                        this.tm.setRollbackOnly();
                    }
                }
                catch (Exception exn) {
                    this.log_.error((Object)"Caught exception rolling back transaction", (Throwable)exn);
                }
                if (!(ex instanceof RuntimeException)) throw new RuntimeException("JBossCacheManager.processSessionRepl(): failed to replicate session.", ex);
                throw (RuntimeException)ex;
            }
            Object var7_4 = null;
            try {
                if (doTx) {
                    this.endTransaction(session.getId());
                }
                Object var9_6 = null;
                SessionReplicationContext.finishCacheActivity();
                return;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                SessionReplicationContext.finishCacheActivity();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            try {}
            catch (Throwable throwable2) {
                Object var9_9 = null;
                SessionReplicationContext.finishCacheActivity();
                throw throwable2;
            }
            if (doTx) {
                this.endTransaction(session.getId());
            }
            Object var9_8 = null;
            SessionReplicationContext.finishCacheActivity();
            throw throwable;
        }
    }

    protected void endTransaction(String id) {
        if (this.tm == null) {
            this.log_.warn((Object)("JBossCacheManager.endTransaction(): tm is null for id: " + id));
            return;
        }
        try {
            if (this.tm.getTransaction().getStatus() != 1) {
                this.tm.commit();
            } else {
                this.log_.info((Object)("JBossCacheManager.endTransaction(): rolling back tx for id: " + id));
                this.tm.rollback();
            }
        }
        catch (RollbackException re) {
            this.log_.warn((Object)("JBossCacheManager.endTransaction(): rolling back transaction with exception: " + (Object)((Object)re)));
        }
        catch (Exception e) {
            throw new RuntimeException("JBossCacheManager.endTransaction(): Exception for id: " + id, e);
        }
    }

    protected ClassLoader getWebappClassLoader() {
        return this.tcl_;
    }

    public void backgroundProcess() {
        this.trace = this.log_.isTraceEnabled();
        super.backgroundProcess();
    }

    protected void processExpires() {
        if (this.maxInactiveInterval_ < 0) {
            return;
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)"Looking for sessions that have expired ...");
        }
        try {
            ClusteredSession[] sessions = this.findLocalSessions();
            for (int i = 0; i < sessions.length; ++i) {
                try {
                    ClusteredSession session = sessions[i];
                    if (session == null) {
                        this.log_.warn((Object)("processExpires(): processing null session at index " + i));
                        continue;
                    }
                    if (session.isOutdated() && !session.isValid(false)) {
                        this.loadSession(session.getRealId());
                    }
                    if (session.isValid()) continue;
                }
                catch (Exception ex) {
                    this.log_.error((Object)("processExpires(): failed expiring " + sessions[i].getIdInternal() + " with exception: " + ex), (Throwable)ex);
                }
            }
            long now = System.currentTimeMillis();
            HashMap unloaded = new HashMap(this.unloadedSessions_);
            Set entries = unloaded.entrySet();
            long maxUnrep = this.maxUnreplicatedInterval_ < 0 ? 60L : (long)this.maxUnreplicatedInterval_;
            long maxUnused = (long)this.maxInactiveInterval_ + maxUnrep;
            for (Map.Entry entry : entries) {
                OwnedSessionUpdate osu = (OwnedSessionUpdate)entry.getValue();
                int elapsed = (int)((now - osu.updateTime) / 1000L);
                if ((long)elapsed < maxUnused) continue;
                String realId = (String)entry.getKey();
                try {
                    this.proxy_.removeSessionLocal(realId, osu.owner);
                    this.unloadedSessions_.remove(realId);
                }
                catch (Exception ex) {
                    this.log_.error((Object)("processExpire(): failed removing unloaded session " + realId + " with exception: " + ex), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            this.log_.error((Object)("processExpires: failed with exception: " + ex), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRemoteAttributeRemoval(String realId, String attrKey) {
        ClusteredSession session = this.findLocalSession(realId);
        if (session != null) {
            boolean localCall = false;
            boolean localOnly = true;
            boolean notify = false;
            ClassLoader prevTcl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.tcl_);
                ClusteredSession clusteredSession = session;
                synchronized (clusteredSession) {
                    session.removeAttributeInternal(attrKey, localCall, localOnly, notify);
                }
                if (this.trace) {
                    this.log_.trace((Object)("processRemoteAttributeRemoval: removed attribute " + attrKey + " from " + realId));
                }
                Object var11_10 = null;
                Thread.currentThread().setContextClassLoader(prevTcl);
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                Thread.currentThread().setContextClassLoader(prevTcl);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRemoteInvalidation(String realId) {
        ClusteredSession session = (ClusteredSession)this.sessions_.remove(realId);
        if (session == null) {
            if (this.unloadedSessions_.remove(realId) != null && this.trace) {
                this.log_.trace((Object)("Removed entry for session " + realId + " from unloaded session map"));
            }
        } else {
            boolean notify = false;
            boolean localCall = false;
            boolean localOnly = true;
            ClassLoader prevTcl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.tcl_);
                session.expire(notify, localCall, localOnly);
                Object var8_7 = null;
                Thread.currentThread().setContextClassLoader(prevTcl);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                Thread.currentThread().setContextClassLoader(prevTcl);
                throw throwable;
            }
            this.stats_.removeStats(realId);
            --this.activeCounter_;
        }
    }

    public void processLocalPojoModification(String realId) {
        ClusteredSession session = this.findLocalSession(realId);
        if (session != null) {
            if (this.trace) {
                this.log_.trace((Object)("Marking attributes of session " + realId + " dirty due to POJO modification"));
            }
            session.sessionAttributesDirty();
        }
    }

    protected String getRealId(String id) {
        return this.useJK_ ? Util.getRealId(id) : id;
    }

    protected void unloadedSessionChanged(String realId, String dataOwner) {
        OwnedSessionUpdate obj = this.unloadedSessions_.put(realId, new OwnedSessionUpdate(dataOwner, System.currentTimeMillis()));
        if (this.trace) {
            if (obj == null) {
                this.log_.trace((Object)("New session " + realId + " added to unloaded session map"));
            } else {
                this.log_.trace((Object)("Updated timestamp for unloaded session " + realId));
            }
        }
    }

    private void startEmbedded() throws LifecycleException {
        super.start();
        this.tcl_ = super.getContainer().getLoader().getClassLoader();
        this.proxy_.start(this.tcl_, this);
        this.tm = this.proxy_.getTransactionManager();
        if (this.tm == null) {
            throw new LifecycleException("JBossCacheManager.start(): Obtain null tm");
        }
        try {
            this.initializeUnloadedSessions();
            this.initSnapshotManager();
            this.installValves();
            this.log_.debug((Object)"start(): JBossCacheService started");
        }
        catch (Exception e) {
            this.log_.error((Object)"Unable to start manager.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
    }

    private void startUnembedded() throws LifecycleException {
        if (this.started_) {
            return;
        }
        if (this.log_.isInfoEnabled()) {
            this.log_.info((Object)"Manager is about to start");
        }
        this.lifecycle_.fireLifecycleEvent("before_start", (Object)this);
        if (this.snapshotMode_ == null) {
            try {
                JBossCacheCluster cluster = (JBossCacheCluster)this.container_.getCluster();
                cluster.configureManager(this);
            }
            catch (ClassCastException e) {
                String msg = "Cluster is not an instance of JBossCacheCluster";
                this.log_.error((Object)msg, (Throwable)e);
                throw new LifecycleException(msg, (Throwable)e);
            }
        }
        if ("SET_AND_GET".equalsIgnoreCase(this.replTriggerString_)) {
            this.invalidateSessionPolicy_ = 1;
        } else if ("SET_AND_NON_PRIMITIVE_GET".equalsIgnoreCase(this.replTriggerString_)) {
            this.invalidateSessionPolicy_ = 2;
        } else if ("SET".equalsIgnoreCase(this.replTriggerString_)) {
            this.invalidateSessionPolicy_ = 3;
        } else {
            throw new LifecycleException("replication-trigger value set to a non-valid value: '" + this.replTriggerString_ + "' (should be ['SET_AND_GET', " + "'SET_AND_NON_PRIMITIVE_GET', 'SET'])");
        }
        if ("SESSION".equalsIgnoreCase(this.replGranularityString_)) {
            this.replicationGranularity_ = 0;
        } else if ("ATTRIBUTE".equalsIgnoreCase(this.replGranularityString_)) {
            this.replicationGranularity_ = 1;
        } else if ("FIELD".equalsIgnoreCase(this.replGranularityString_)) {
            this.replicationGranularity_ = 2;
        } else {
            throw new LifecycleException("replication-granularity value set to a non-valid value: '" + this.replGranularityString_ + "' (should be ['SESSION', " + "'ATTRIBUTE' or 'FIELD'])");
        }
        try {
            this.proxy_ = new JBossCacheService(this.cacheObjectNameString_);
            this.validateFieldMarshalling();
            this.tcl_ = this.container_.getLoader().getClassLoader();
            this.proxy_.start(this.tcl_, this);
        }
        catch (Throwable t) {
            String str = "Problem starting JBossCacheService for Tomcat clustering";
            this.log_.error((Object)str, t);
            throw new LifecycleException(str, t);
        }
        this.tm = this.proxy_.getTransactionManager();
        if (this.tm == null) {
            throw new LifecycleException("JBossCacheManager.start(): Obtain null tm");
        }
        try {
            this.initializeUnloadedSessions();
            this.installValves();
            this.started_ = true;
            this.lifecycle_.fireLifecycleEvent("after_start", (Object)this);
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)"start(): JBossCacheService started");
            }
        }
        catch (Exception e) {
            this.log_.error((Object)"Unable to start manager.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
        try {
            this.registerMBeans();
        }
        catch (Exception e) {
            this.log_.error((Object)"Could not register ManagerMBean with MBeanServer", (Throwable)e);
        }
    }

    private void registerMBeans() {
        try {
            MBeanServer server = this.getMBeanServer();
            String domain = this.container_ instanceof ContainerBase ? ((ContainerBase)this.container_).getDomain() : server.getDefaultDomain();
            String hostName = ((Host)this.container_.getParent()).getName();
            hostName = hostName == null ? "localhost" : hostName;
            ObjectName clusterName = new ObjectName(domain + ":service=ClusterManager,WebModule=//" + hostName + ((Context)this.container_).getPath());
            if (server.isRegistered(clusterName)) {
                this.log_.warn((Object)("MBean " + clusterName + " already registered"));
                return;
            }
            this.objectName_ = clusterName;
            server.registerMBean(this, clusterName);
        }
        catch (Exception ex) {
            this.log_.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void unregisterMBeans() {
        if (this.mserver_ != null) {
            try {
                this.mserver_.unregisterMBean(this.objectName_);
            }
            catch (Exception e) {
                this.log_.error((Object)e);
            }
        }
    }

    private MBeanServer getMBeanServer() throws Exception {
        if (this.mserver_ == null) {
            this.mserver_ = MBeanServerLocator.locateJBoss();
        }
        return this.mserver_;
    }

    private void initializeUnloadedSessions() throws CacheException {
        Map sessions = this.proxy_.getSessionIds();
        if (sessions != null) {
            long now = System.currentTimeMillis();
            for (Map.Entry entry : sessions.entrySet()) {
                this.unloadedSessions_.put(entry.getKey(), new OwnedSessionUpdate((String)entry.getValue(), now));
            }
        }
    }

    private void installValves() {
        if (this.useJK_) {
            this.log_.info((Object)"We are using mod_jk(2) for load-balancing. Will add JvmRouteValve.");
            this.installContextValve((Valve)new JvmRouteValve(this));
        }
        if (this.replicationGranularity_ == 2 && Boolean.TRUE.equals(this.replicationFieldBatchMode_)) {
            BatchReplicationClusteredSessionValve batchValve = new BatchReplicationClusteredSessionValve(this);
            this.log_.debug((Object)"Adding BatchReplicationClusteredSessionValve for batch replication.");
            this.installContextValve((Valve)batchValve);
        }
        ClusteredSessionValve valve = new ClusteredSessionValve(this);
        this.installContextValve((Valve)valve);
    }

    private void initSnapshotManager() {
        String ctxPath = ((Context)this.container_).getPath();
        if ("instant".equals(this.snapshotMode_) || this.replicationGranularity_ == 2) {
            this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
        } else if ("interval".equals(this.snapshotMode_)) {
            this.snapshotManager_ = new IntervalSnapshotManager(this, ctxPath, this.snapshotInterval_);
        } else {
            this.log_.error((Object)"Snapshot mode must be 'instant' or 'interval' - using 'instant'");
            this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
        }
        this.snapshotManager_.start();
    }

    private void installContextValve(Valve valve) {
        boolean installed = false;
        if (this.embedded_ && this.getContextObjectName() != null) {
            try {
                this.getMBeanServer().invoke(this.getContextObjectName(), "addValve", new Object[]{valve}, new String[]{"org.apache.catalina.Valve"});
                installed = true;
            }
            catch (Exception e) {
                this.log_.debug((Object)"Caught exception installing valve to Context", (Throwable)e);
            }
        }
        if (!installed) {
            if (this.container_ instanceof ContainerBase) {
                ((ContainerBase)this.container_).addValve(valve);
            } else {
                this.container_.getPipeline().addValve(valve);
            }
        }
    }

    private void validateFieldMarshalling() {
        if (this.replicationGranularity_ == 2 && !this.proxy_.isMarshallingAvailable()) {
            throw new IllegalStateException("replication-granularity value is set to 'FIELD' but is not supported by the cache service configuration. Must set 'UseRegionBasedMarshalling' to 'true' in the tc5-cluster.sar jboss-service.xml");
        }
    }

    private ObjectName getContextObjectName() {
        String oname = this.container_.getObjectName();
        try {
            return oname == null ? null : new ObjectName(oname);
        }
        catch (MalformedObjectNameException e) {
            this.log_.warn((Object)("Error creating object name from string " + oname), (Throwable)e);
            return null;
        }
    }

    private class OwnedSessionUpdate {
        String owner;
        long updateTime;

        OwnedSessionUpdate(String owner, long updateTime) {
            this.owner = owner;
            this.updateTime = updateTime;
        }
    }
}

