/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.ui.content.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.xml.namespace.QName;
import org.jboss.portal.Mode;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.info.ModeInfo;
import org.jboss.portal.portlet.info.PortletInfo;

public class PortletContentEditorPortlet
extends GenericPortlet {
    public static final String DEFAULT_PORTLET_ICON = "/portal-core/images/portletIcon_Default1.gif";
    private final PortletMode EDIT_CONTENT = new PortletMode("edit_content");
    private final Mode INTERNAL_EDIT_CONTENT = Mode.create((String)"edit_content");
    private InstanceContainer instanceContainer;
    private static final QName CONTENT_SELECT = new QName("urn:jboss:portal:content", "select");
    private static final String CONTENT_URI = "content.uri";

    public void init() throws PortletException {
        this.instanceContainer = (InstanceContainer)this.getPortletContext().getAttribute("InstanceContainer");
    }

    public void processAction(ActionRequest req, ActionResponse resp) throws PortletException, PortletSecurityException, IOException {
        String uri;
        if (req.getPortletMode().equals((Object)this.EDIT_CONTENT) && (uri = req.getParameter(CONTENT_URI)) != null) {
            resp.setRenderParameter(CONTENT_URI, uri);
            resp.setEvent(CONTENT_SELECT, (Serializable)((Object)uri));
        }
    }

    protected void doDispatch(RenderRequest req, RenderResponse resp) throws PortletException, PortletSecurityException, IOException {
        if (this.EDIT_CONTENT.equals((Object)req.getPortletMode())) {
            this.doEditContent(req, resp);
        } else {
            super.doDispatch(req, resp);
        }
    }

    protected void doView(RenderRequest req, RenderResponse resp) throws PortletException, PortletSecurityException, IOException {
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        writer.write("This portlet is not made to be viewed");
        writer.close();
    }

    protected void doEditContent(RenderRequest req, RenderResponse resp) throws PortletException, PortletSecurityException, IOException {
        this.getContent(req, resp, false);
    }

    protected void getContent(RenderRequest req, RenderResponse resp, boolean newContent) throws PortletException, PortletSecurityException, IOException {
        String selectedURI = req.getParameter(CONTENT_URI);
        if (selectedURI == null) {
            selectedURI = req.getParameter("uri");
        }
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        ArrayList<InstanceDefinition> available_instances = new ArrayList<InstanceDefinition>();
        block2: for (InstanceDefinition instance : this.instanceContainer.getDefinitions()) {
            try {
                Portlet portlet = instance.getPortlet();
                PortletInfo portletInfo = portlet.getInfo();
                for (ModeInfo modeInfo : portletInfo.getCapabilities().getAllModes()) {
                    if (!modeInfo.getMode().equals((Object)this.INTERNAL_EDIT_CONTENT)) continue;
                    continue block2;
                }
                available_instances.add(instance);
            }
            catch (PortletInvokerException ignore) {}
        }
        Comparator<Instance> simpleComparator = new Comparator<Instance>(){

            @Override
            public int compare(Instance i1, Instance i2) {
                return i1.getId().compareToIgnoreCase(i2.getId());
            }
        };
        Collections.sort(available_instances, simpleComparator);
        Instance selectedInstance = null;
        for (Instance instance : available_instances) {
            if (!instance.getId().equals(selectedURI)) continue;
            selectedInstance = instance;
        }
        req.setAttribute("INSTANCES", available_instances);
        req.setAttribute("SELECTED_INSTANCE", selectedInstance);
        req.setAttribute("NEW_CONTENT", (Object)newContent);
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/content/portlet_editor.jsp");
        dispatcher.include(req, resp);
        writer.close();
    }
}

