/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.jems.hibernate;

import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.OptimisticTreeCache;
import org.hibernate.cache.TreeCache;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.portal.jems.hibernate.TreeCacheProvider;

public class JMXTreeCacheProvider
implements CacheProvider {
    private static final Logger log = Logger.getLogger(JMXTreeCacheProvider.class);

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        try {
            String objectNameAsString = properties.getProperty("hibernate.cache.object_name");
            log.debug((Object)("Uses tree cache provider with object name " + objectNameAsString));
            ObjectName providerName = ObjectName.getInstance(objectNameAsString);
            MBeanServer server = MBeanServerLocator.locateJBoss();
            TreeCacheProvider provider = (TreeCacheProvider)MBeanProxy.get(TreeCacheProvider.class, (ObjectName)providerName, (MBeanServer)server);
            org.jboss.cache.TreeCache cache = provider.getTreeCache();
            OptimisticTreeCache hibernateCache = null;
            if (cache.getNodeLockingScheme().equalsIgnoreCase("OPTIMISTIC")) {
                log.debug((Object)"Selecting Optimistic Cache");
                hibernateCache = new OptimisticTreeCache(cache, regionName);
            } else {
                log.debug((Object)"Selecting regular Tree Cache");
                hibernateCache = new TreeCache(cache, regionName, cache.getTransactionManager());
            }
            return hibernateCache;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void start(Properties properties) throws CacheException {
    }

    public void stop() {
    }
}

