/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import org.jboss.logging.Logger;
import org.jboss.portal.common.text.FastURLDecoder;
import org.jboss.portal.core.identity.services.metadata.CoreIdentityConfigurationException;
import org.jboss.portal.core.identity.services.workflow.RegistrationService;
import org.jboss.portal.core.identity.services.workflow.UserContainer;
import org.jboss.portal.core.identity.ui.IdentityUIUser;
import org.jboss.portal.core.identity.ui.common.IdentityRoleBean;
import org.jboss.portal.core.identity.ui.common.IdentityUserBean;
import org.jboss.portal.identity.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAdministrationBean {
    private String currentUser;
    private ListDataModel userList;
    private int page = 1;
    private String limit = "10";
    private int userCount = 0;
    private List<String> roles = new ArrayList<String>();
    private String displayNode = "admin_approval";
    private String subscriptionMode;
    private String adminSubscriptionMode;
    private List<UserContainer> pendingUsers = null;
    private List<UserContainer> pendingActionList = null;
    private String pendingUserAction = null;
    private IdentityUIUser uiUser;
    private String searchString = "";
    private IdentityUserBean identityUserBean;
    private IdentityRoleBean identityRoleBean;
    private RegistrationService registrationService;
    private static final Logger log = Logger.getLogger(UserAdministrationBean.class);
    private static final FastURLDecoder decoder = FastURLDecoder.getUTF8Instance();
    private boolean isNewSearch = true;

    public DataModel getUserList() {
        if (this.userList == null) {
            this.searchUsers();
        }
        return this.userList;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public IdentityUIUser getUiUser() {
        return this.uiUser;
    }

    public void setUiUser(IdentityUIUser uiUser) {
        this.uiUser = uiUser;
    }

    public String getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public void setSubscriptionMode(String subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public String getAdminSubscriptionMode() {
        return this.adminSubscriptionMode;
    }

    public void setAdminSubscriptionMode(String adminSubscriptionMode) {
        this.adminSubscriptionMode = adminSubscriptionMode;
    }

    public IdentityUserBean getIdentityUserBean() {
        return this.identityUserBean;
    }

    public String getPendingUserAction() {
        return this.pendingUserAction;
    }

    public List<UserContainer> getPendingActionList() {
        return this.pendingActionList;
    }

    public void setIdentityUserBean(IdentityUserBean identityUserBean) {
        this.identityUserBean = identityUserBean;
    }

    public IdentityRoleBean getIdentityRoleBean() {
        return this.identityRoleBean;
    }

    public void setIdentityRoleBean(IdentityRoleBean identityRoleBean) {
        this.identityRoleBean = identityRoleBean;
    }

    public RegistrationService getRegistrationService() {
        return this.registrationService;
    }

    public void setRegistrationService(RegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public String searchUsers() {
        if (this.searchString != null) {
            try {
                int initLimit = Integer.valueOf(this.limit);
                int offset = 0;
                if (!this.isNewSearch) {
                    offset = this.page > 0 ? (this.page - 1) * initLimit : 0;
                    this.isNewSearch = true;
                } else {
                    this.page = 1;
                }
                int limit1 = initLimit + 1;
                this.userList = new ListDataModel(this.identityUserBean.findUsersFilteredByUserName(this.searchString, offset, limit1));
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
                ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", FacesContext.getCurrentInstance().getViewRoot().getLocale());
                FacesContext.getCurrentInstance().addMessage("status", new FacesMessage(bundle.getString("IDENTITY_MANAGEMENT_ERROR_ACTION_USER")));
            }
        }
        return "searchUsers";
    }

    public String enableUser() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = ctx.getExternalContext();
        Map params = ectx.getRequestParameterMap();
        String action = (String)params.get("enableAction");
        ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", ctx.getViewRoot().getLocale());
        String string = this.currentUser = params.get("currentUser") != null ? decoder.encode((String)params.get("currentUser")) : null;
        if (this.currentUser != null && action != null) {
            HashMap<String, Object> profileMap = new HashMap<String, Object>();
            try {
                User user = this.identityUserBean.findUserByUserName(this.currentUser);
                if (action.equals("enable")) {
                    profileMap.put("enabled", Boolean.TRUE);
                } else if (action.equals("disable")) {
                    profileMap.put("enabled", Boolean.FALSE);
                }
                this.identityUserBean.updateProfile(user, profileMap);
            }
            catch (Exception e) {
                log.error((Object)("unable to get user: " + this.currentUser), (Throwable)e);
                ctx.addMessage("status", new FacesMessage(bundle.getString("IDENTITY_MANAGEMENT_ERROR_ACTION_USER")));
                return "userAdmin";
            }
            if (action.equals("enable")) {
                ctx.addMessage("status", new FacesMessage(bundle.getString("IDENTITY_MANAGEMENT_ENABLE_USER_ENABLED")));
            } else if (action.equals("disable")) {
                ctx.addMessage("status", new FacesMessage(bundle.getString("IDENTITY_MANAGEMENT_DISABLE_USER_DISABLED")));
            }
            return this.searchUsers();
        }
        return "searchUsers";
    }

    public int getPendingCount() {
        try {
            return this.registrationService.getPendingCount();
        }
        catch (CoreIdentityConfigurationException e) {
            log.error((Object)"", (Throwable)e);
            return -1;
        }
    }

    public int getUserCount() {
        if (this.userCount == 0) {
            try {
                this.userCount = this.identityUserBean.getUserModule().getUserCount();
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
                ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", FacesContext.getCurrentInstance().getViewRoot().getLocale());
                FacesContext.getCurrentInstance().addMessage("status", new FacesMessage(bundle.getString("IDENTITY_MANAGEMENT_ERROR_ACTION_USER")));
            }
        }
        return this.userCount;
    }

    public List<UserContainer> getPendingUsers() {
        try {
            if (this.registrationService != null && this.pendingUsers == null) {
                this.pendingUsers = this.registrationService.getPendingUsers(this.displayNode);
            }
        }
        catch (CoreIdentityConfigurationException e) {
            log.error((Object)"", (Throwable)e);
        }
        return this.pendingUsers;
    }

    public String deleteUser() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = ctx.getExternalContext();
        Map params = ectx.getRequestParameterMap();
        String string = this.currentUser = params.get("currentUser") != null ? decoder.encode((String)params.get("currentUser")) : null;
        if (this.currentUser != null) {
            this.uiUser = new IdentityUIUser(this.currentUser);
            return "deleteUser";
        }
        return "userAdmin";
    }

    public String confirmedDelete() {
        ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", FacesContext.getCurrentInstance().getViewRoot().getLocale());
        try {
            User user = this.identityUserBean.findUserByUserName(this.uiUser.getUsername());
            this.identityUserBean.getUserModule().removeUser(user.getId());
            FacesContext.getCurrentInstance().addMessage("status", new FacesMessage(bundle.getString("IDENTITY_MANAGEMENT_USER_DELETED")));
            this.searchUsers();
            return "userAdmin";
        }
        catch (Exception e) {
            log.error((Object)"unable delete user.", (Throwable)e);
            FacesContext.getCurrentInstance().addMessage("status", new FacesMessage(bundle.getString("IDENTITY_MANAGEMENT_ERROR_ACTION_USER")));
            return "userAdmin";
        }
    }

    public String nextPage() {
        this.isNewSearch = false;
        ++this.page;
        this.searchUsers();
        return "searchUsers";
    }

    public String prevPage() {
        this.isNewSearch = false;
        --this.page;
        this.searchUsers();
        return "searchUsers";
    }

    public String approveRegistration() {
        ExternalContext ectx = FacesContext.getCurrentInstance().getExternalContext();
        Map params = ectx.getRequestParameterMap();
        String processId = (String)params.get("processId");
        String action = (String)params.get("action");
        try {
            if (processId != null && action != null) {
                if (action.equals("approve")) {
                    this.registrationService.approve(processId, true);
                } else if (action.equals("reject")) {
                    this.registrationService.approve(processId, false);
                }
            }
        }
        catch (CoreIdentityConfigurationException e) {
            log.error((Object)"", (Throwable)e);
            return "userAdmin";
        }
        this.pendingUsers = null;
        this.getPendingUsers();
        if (this.pendingUsers.size() > 0) {
            return "pendingUsers";
        }
        return "userAdmin";
    }

    public String approveList() {
        this.pendingUserAction = "approve";
        this.pendingActionList = new ArrayList<UserContainer>();
        for (UserContainer user : this.pendingUsers) {
            if (!user.isSelected()) continue;
            this.pendingActionList.add(user);
        }
        if (this.pendingActionList.size() > 0) {
            return "confirmPendingAction";
        }
        return "pendingUsers";
    }

    public String rejectList() {
        this.pendingUserAction = "reject";
        this.pendingActionList = new ArrayList<UserContainer>();
        for (UserContainer user : this.pendingUsers) {
            if (!user.isSelected()) continue;
            this.pendingActionList.add(user);
        }
        if (this.pendingActionList.size() > 0) {
            return "confirmPendingAction";
        }
        return "pendingUsers";
    }

    public String confirmPendingAction() {
        try {
            for (UserContainer user : this.pendingActionList) {
                if (this.pendingUserAction.equals("approve")) {
                    this.registrationService.approve(user.getProcessId(), true);
                    continue;
                }
                if (!this.pendingUserAction.equals("reject")) continue;
                this.registrationService.approve(user.getProcessId(), false);
            }
        }
        catch (CoreIdentityConfigurationException e) {
            log.error((Object)"", (Throwable)e);
        }
        this.pendingActionList = null;
        this.pendingUsers = null;
        return "success";
    }
}

