/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.registration.policies;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.registration.Consumer;
import org.jboss.portal.registration.DuplicateRegistrationException;
import org.jboss.portal.registration.InvalidConsumerDataException;
import org.jboss.portal.registration.PropertyDescription;
import org.jboss.portal.registration.Registration;
import org.jboss.portal.registration.RegistrationException;
import org.jboss.portal.registration.RegistrationManager;
import org.jboss.portal.registration.RegistrationPolicy;
import org.jboss.portal.registration.RegistrationStatus;
import org.jboss.portal.registration.policies.RegistrationPropertyValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRegistrationPolicy
extends AbstractJBossService
implements RegistrationPolicy {
    private RegistrationManager manager;
    private RegistrationPropertyValidator validator;
    private Map<QName, ? extends PropertyDescription> expectations;

    @Override
    public RegistrationManager getManager() {
        return this.manager;
    }

    @Override
    public void setManager(RegistrationManager manager) {
        this.manager = manager;
    }

    @Override
    public void setExpectations(Map<QName, ? extends PropertyDescription> registrationPropertyDescriptions) {
        this.expectations = registrationPropertyDescriptions;
    }

    @Override
    public void validateRegistrationDataFor(Map<QName, ? extends PropertyDescription> registrationProperties, String consumerIdentity) throws IllegalArgumentException, RegistrationException {
        Consumer consumer;
        ParameterValidation.throwIllegalArgExceptionIfNull(registrationProperties, (String)"Registration properties");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerIdentity, (String)"Consumer identity", null);
        StringBuilder message = new StringBuilder();
        if (this.expectations != null) {
            Set<QName> expectedNames = this.expectations.keySet();
            boolean consistentWithExpectations = true;
            HashSet<QName> unexpected = new HashSet<QName>(registrationProperties.keySet());
            unexpected.removeAll(expectedNames);
            if (!unexpected.isEmpty()) {
                consistentWithExpectations = false;
                message.append("Consumer '").append(consumerIdentity).append("' provided values for unexpected registration properties:\n");
                for (QName name : unexpected) {
                    message.append("\t- ").append(name).append("\n");
                }
            }
            for (Map.Entry<QName, ? extends PropertyDescription> entry : this.expectations.entrySet()) {
                QName name = entry.getKey();
                PropertyDescription value = registrationProperties.get(name);
                try {
                    this.validator.validateValueFor(name, value);
                }
                catch (IllegalArgumentException e) {
                    message.append("Missing value for expected '").append(name.getLocalPart()).append("' property.\n");
                    consistentWithExpectations = false;
                }
            }
            if (!consistentWithExpectations) {
                this.log.debug((Object)message);
                throw new InvalidConsumerDataException(message.toString());
            }
        }
        if ((consumer = this.manager.getConsumerByIdentity(consumerIdentity)) != null && !RegistrationStatus.PENDING.equals(consumer.getStatus())) {
            for (Object o : consumer.getRegistrations()) {
                Registration registration = (Registration)o;
                if (!registration.hasEqualProperties(registrationProperties)) continue;
                throw new DuplicateRegistrationException("Consumer named '" + consumer.getName() + "' has already been registered with the same set of registration properties. Registration rejected!");
            }
        }
    }

    @Override
    public String createRegistrationHandleFor(String registrationId) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationId, (String)"Registration id", null);
        return registrationId;
    }

    @Override
    public String getAutomaticGroupNameFor(String consumerName) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"Consumer name", null);
        return null;
    }

    @Override
    public String getConsumerIdFrom(String consumerName, Map registrationProperties) throws IllegalArgumentException, InvalidConsumerDataException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"Consumer name", null);
        return consumerName;
    }

    @Override
    public void validateConsumerName(String consumerName) throws IllegalArgumentException, RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"Consumer name", null);
        Consumer consumer = this.manager.getConsumerByIdentity(this.getConsumerIdFrom(consumerName, Collections.EMPTY_MAP));
        if (consumer != null) {
            throw new DuplicateRegistrationException("A Consumer named '" + consumerName + "' has already been registered.");
        }
    }

    @Override
    public void validateConsumerGroupName(String groupName) throws IllegalArgumentException, RegistrationException {
    }

    public void setValidator(RegistrationPropertyValidator validator) {
        this.validator = validator;
    }

    public RegistrationPropertyValidator getValidator() {
        return this.validator;
    }
}

