/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.mapping;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.encoding.TypeMapping;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.tools.JavaWriter;
import org.jboss.ws.tools.NamespacePackageMapping;
import org.jboss.ws.tools.XSDTypeToJava;
import org.jboss.ws.tools.helpers.MappingFileGeneratorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingFileGenerator {
    protected WSDLDefinitions wsdlDefinitions;
    protected Map<String, String> namespacePackageMap = new HashMap<String, String>();
    protected String serviceName;
    protected String packageName;
    protected Class serviceEndpointInterface = null;
    protected LiteralTypeMapping typeMapping = null;
    protected String parameterStyle;

    public MappingFileGenerator(WSDLDefinitions wsdl, TypeMapping typeM) {
        this.wsdlDefinitions = wsdl;
        String targetNS = wsdl.getTargetNamespace();
        this.packageName = NamespacePackageMapping.getJavaPackageName(targetNS);
        this.typeMapping = (LiteralTypeMapping)typeM;
    }

    public WSDLDefinitions getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }

    public void setWsdlDefinitions(WSDLDefinitions wsdlDefinitions) {
        this.wsdlDefinitions = wsdlDefinitions;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Map<String, String> getNamespacePackageMap() {
        return this.namespacePackageMap;
    }

    public void setNamespacePackageMap(Map<String, String> map) {
        this.namespacePackageMap = map;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceEndpointInterface(Class serviceEndpointInterface) {
        this.serviceEndpointInterface = serviceEndpointInterface;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setParameterStyle(String paramStyle) {
        this.parameterStyle = paramStyle;
    }

    public JavaWsdlMapping generate() throws IOException {
        MappingFileGeneratorHelper helper = new MappingFileGeneratorHelper(this.wsdlDefinitions, this.serviceName, this.namespacePackageMap, this.serviceEndpointInterface, this.typeMapping, this.parameterStyle);
        JavaWsdlMapping jwm = new JavaWsdlMapping();
        helper.constructJavaXmlTypeMapping(jwm);
        WSDLService[] services = this.wsdlDefinitions.getServices();
        int lenServices = 0;
        if (services != null) {
            lenServices = services.length;
        }
        for (int i = 0; i < lenServices; ++i) {
            WSDLService wsdlService = services[i];
            jwm.addServiceInterfaceMappings(helper.constructServiceInterfaceMapping(jwm, wsdlService));
            helper.constructServiceEndpointInterfaceMapping(jwm, wsdlService);
        }
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        String typeNamespace = helper.getTypeNamespace();
        if (typeNamespace == null) {
            typeNamespace = targetNS;
        }
        if (typeNamespace != null && !typeNamespace.equals(targetNS) || this.isServerSideGeneration()) {
            jwm.addPackageMapping(helper.constructPackageMapping(jwm, this.getPackageName(typeNamespace), typeNamespace));
        }
        jwm.addPackageMapping(helper.constructPackageMapping(jwm, this.getPackageName(targetNS), targetNS));
        if (this.namespacePackageMap != null) {
            Set<String> keys = this.namespacePackageMap.keySet();
            Iterator<String> iter = keys.iterator();
            while (iter != null && iter.hasNext()) {
                String ns = iter.next();
                if (jwm.getPackageNameForNamespaceURI(ns) != null) continue;
                jwm.addPackageMapping(helper.constructPackageMapping(jwm, this.namespacePackageMap.get(ns), ns));
            }
        }
        return jwm;
    }

    public void generateJavaSourceFileForRequestResponseStruct(File location, ServiceEndpointInterfaceMapping seim, JBossXSModel xsmodel, String typeNamespace) throws IOException {
        WSDLUtils utils = WSDLUtils.getInstance();
        XSDTypeToJava xst = new XSDTypeToJava(this.namespacePackageMap);
        xst.setTypeMapping(this.typeMapping);
        xst.setPackageName(this.getPackageName(typeNamespace));
        ServiceEndpointMethodMapping[] mapArr = seim.getServiceEndpointMethodMappings();
        int len = mapArr != null ? mapArr.length : 0;
        for (int i = 0; i < len; ++i) {
            ServiceEndpointMethodMapping mm = mapArr[i];
            String opname = mm.getJavaMethodName();
            String sei = seim.getServiceEndpointInterface();
            String plainClassName = WSDLUtils.getJustClassName(sei);
            String classname = plainClassName + "_" + opname + "_RequestStruct";
            ArrayList<XSDTypeToJava.VAR> listInputs = new ArrayList<XSDTypeToJava.VAR>();
            MethodParamPartsMapping[] mppmarr = mm.getMethodParamPartsMappings();
            int lenmppmarr = mppmarr != null ? mppmarr.length : 0;
            for (int j = 0; j < lenmppmarr; ++j) {
                listInputs.addAll(xst.getVARList((XSComplexTypeDefinition)xsmodel.getTypeDefinition(opname, typeNamespace), xsmodel, false));
            }
            JavaWriter jw = new JavaWriter();
            jw.createJavaFile(location, classname, this.getPackageName(typeNamespace), listInputs, null, null, false, null);
            classname = plainClassName + "_" + opname + "_ResponseStruct";
            XSTypeDefinition xt = xsmodel.getTypeDefinition(opname + "Response", typeNamespace);
            ArrayList<XSDTypeToJava.VAR> listOutputs = new ArrayList<XSDTypeToJava.VAR>();
            if (xt instanceof XSSimpleTypeDefinition) {
                listOutputs.add(new XSDTypeToJava.VAR("result", xt.getName(), false));
            } else {
                listOutputs.addAll(xst.getVARList((XSComplexTypeDefinition)xt, xsmodel, false));
            }
            jw.createJavaFile(location, classname, this.getPackageName(typeNamespace), listOutputs, null, null, false, null);
        }
    }

    private boolean isServerSideGeneration() {
        return this.serviceEndpointInterface != null;
    }

    private String getPackageName(String targetNamespace) {
        String pkg;
        if (this.namespacePackageMap != null && (pkg = this.namespacePackageMap.get(targetNamespace)) != null) {
            return pkg;
        }
        return this.packageName;
    }
}

