/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.deployment;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.server.deployment.CannotCreatePortletWebAppException;
import org.jboss.portal.web.WebApp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public abstract class PortalWebApp
implements WebApp {
    protected final Logger log = Logger.getLogger(this.getClass());
    private Document descriptor;
    private ServletContext servletContext;
    private ClassLoader loader;
    private URL url;
    private String id;
    private String contextPath;

    protected PortalWebApp() {
    }

    public abstract void instrument() throws Exception;

    public final URL getURL() {
        return this.url;
    }

    public final String getId() {
        return this.id;
    }

    public final ClassLoader getClassLoader() {
        return this.loader;
    }

    public final String getContextPath() {
        return this.contextPath;
    }

    public final ServletContext getServletContext() {
        return this.servletContext;
    }

    public final Document getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean importFile(String parentDirRelativePath, String name, InputStream source, boolean overwrite) throws IOException {
        ServletContext ctx = this.getServletContext();
        String contextPath = this.getContextPath();
        String parentAbsolutePath = ctx.getRealPath(parentDirRelativePath);
        File parentDir = new File(parentAbsolutePath);
        if (parentDir.exists()) {
            if (parentDir.isFile()) {
                throw new IOException("Target parent dir " + parentDirRelativePath + " already exists in the web application  and is a file " + contextPath);
            }
        } else if (!parentDir.mkdirs()) {
            throw new IOException("Was not able to create the parent dir " + parentDirRelativePath + " in the web application " + contextPath);
        }
        boolean done = false;
        File targetFile = new File(parentDir, name);
        if (overwrite || !targetFile.exists()) {
            BufferedOutputStream target = null;
            try {
                target = IOTools.safeBufferedWrapper((OutputStream)new FileOutputStream(new File(parentDir, name)));
                IOTools.copy((InputStream)source, (OutputStream)target);
                done = true;
                this.log.debug((Object)("Copied file" + name + " to location " + parentDirRelativePath));
            }
            catch (Throwable throwable) {
                IOTools.safeClose(target);
                throw throwable;
            }
            IOTools.safeClose((Closeable)target);
        }
        return done;
    }

    protected final void init(ServletContext servletContext, URL url, ClassLoader loader, String contextPath, EntityResolver jbossAppEntityResolver) throws CannotCreatePortletWebAppException {
        Element jbossAppElt;
        Element appNameElt;
        this.servletContext = servletContext;
        this.url = url;
        this.loader = loader;
        this.contextPath = contextPath;
        this.id = contextPath;
        this.readJBossAppDescriptor(jbossAppEntityResolver);
        if (this.descriptor != null && (appNameElt = XMLTools.getUniqueChild((Element)(jbossAppElt = this.descriptor.getDocumentElement()), (String)"app-name", (boolean)false)) != null) {
            this.id = XMLTools.asString((Element)appNameElt);
            this.log.debug((Object)("Detected explicit app name = " + this.id + " for application under path " + this.getContextPath()));
        }
    }

    /*
     * Exception decompiling
     */
    private void readJBossAppDescriptor(EntityResolver jbossAppEntityResolver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return "WebApp[" + this.getContextPath() + "]";
    }
}

