/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.deployment;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.server.config.ServerConfig;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.WebAppIntercepter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebAppEnhancer
extends WebAppIntercepter {
    private ServerConfig config;

    public ServerConfig getConfig() {
        return this.config;
    }

    public void setConfig(ServerConfig config) {
        this.config = config;
    }

    protected void deploy(PortalWebApp pwa) {
        try {
            pwa.instrument();
            Document desc = pwa.getDescriptor();
            if (desc != null) {
                Element jbossAppElt = desc.getDocumentElement();
                for (Element serviceElt : XMLTools.getChildren((Element)jbossAppElt, (String)"service")) {
                    this.log.debug((Object)("About to inject a service in the servlet context of " + pwa.getURL()));
                    Element serviceNameElt = XMLTools.getUniqueChild((Element)serviceElt, (String)"service-name", (boolean)true);
                    Element serviceClassElt = XMLTools.getUniqueChild((Element)serviceElt, (String)"service-class", (boolean)true);
                    Element serviceRefElt = XMLTools.getUniqueChild((Element)serviceElt, (String)"service-ref", (boolean)true);
                    String serviceName = XMLTools.asString((Element)serviceNameElt);
                    String serviceClass = XMLTools.asString((Element)serviceClassElt);
                    String serviceRef = XMLTools.asString((Element)serviceRefElt);
                    if (serviceRef.startsWith(":")) {
                        this.log.debug((Object)("Detecting a relative service reference " + serviceRef + " prepending it with " + this.config.getDomain()));
                        serviceRef = this.config.getDomain() + serviceRef;
                    }
                    Class<?> proxyClass = pwa.getClassLoader().loadClass(serviceClass);
                    ObjectName objectName = ObjectName.getInstance(serviceRef);
                    Object proxy = MBeanProxy.get(proxyClass, (ObjectName)objectName, (MBeanServer)this.server);
                    this.log.debug((Object)("Want to inject " + serviceRef + " with class " + proxy + " and name " + serviceName));
                    pwa.getServletContext().setAttribute(serviceName, proxy);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot instrument the web application", (Throwable)e);
        }
    }

    protected void undeploy(PortalWebApp jwa) {
    }
}

