/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.ajax;

import java.util.Map;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerInterceptor;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.navstate.NavigationalStateContext;
import org.jboss.portal.core.theme.PageRendition;
import org.jboss.portal.server.AbstractServerURL;
import org.jboss.portal.server.ServerInvocationContext;
import org.jboss.portal.server.ServerURL;
import org.jboss.portal.server.request.URLFormat;

public class AjaxInterceptor
extends ControllerInterceptor {
    private String targetContextPath = "/portal-ajax";

    public ControllerResponse invoke(ControllerCommand cmd) throws Exception, InvocationException {
        ControllerResponse response = (ControllerResponse)cmd.invokeNext();
        if (response instanceof PageRendition) {
            ServerInvocationContext serverContext = cmd.getControllerContext().getServerInvocation().getServerContext();
            ControllerContext controllerContext = cmd.getControllerContext();
            PageRendition rendition = (PageRendition)response;
            Map pageProps = rendition.getPageResult().getProperties();
            NavigationalStateContext ctx = (NavigationalStateContext)controllerContext.getAttributeResolver(ControllerCommand.NAVIGATIONAL_STATE_SCOPE);
            String viewId = ctx.getViewId();
            AbstractServerURL baseServerURL = new AbstractServerURL();
            baseServerURL.setPortalRequestPath("/");
            String url = serverContext.renderURL((ServerURL)baseServerURL, serverContext.getURLContext(), URLFormat.newInstance((boolean)true, (boolean)true));
            pageProps.put("theme.dyna.resource_base_url", this.targetContextPath + "/dyna");
            pageProps.put("theme.dyna.server_base_url", url);
            pageProps.put("theme.dyna.view_state", viewId);
        }
        return response;
    }

    public String getTargetContextPath() {
        return this.targetContextPath;
    }

    public void setTargetContextPath(String context) {
        this.targetContextPath = context;
    }
}

