/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.instance;

import org.jboss.logging.Logger;
import org.jboss.portal.Mode;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.core.model.instance.InstancePermission;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.PortletInvokerInterceptor;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.InsufficientPrivilegesResponse;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;

public class InstanceSecurityInterceptor
extends PortletInvokerInterceptor {
    private Logger log = Logger.getLogger(InstanceSecurityInterceptor.class);
    private boolean trace = this.log.isTraceEnabled();
    private PortalAuthorizationManagerFactory pamf;

    public PortalAuthorizationManagerFactory getPortalAuthorizationManagerFactory() {
        return this.pamf;
    }

    public void setPortalAuthorizationManagerFactory(PortalAuthorizationManagerFactory portalAuthorizationManagerFactory) {
        this.pamf = portalAuthorizationManagerFactory;
    }

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        try {
            int mask = 1;
            Mode mode = invocation.getMode();
            if (Mode.ADMIN.equals((Object)mode)) {
                mask |= 0xF;
            }
            String instanceid = (String)invocation.getAttribute("instanceid");
            PortalAuthorizationManager pam = this.pamf.getManager();
            InstancePermission perm = new InstancePermission(instanceid, mask);
            boolean authorized = pam.checkPermission((PortalPermission)perm);
            if (this.trace) {
                this.log.trace((Object)("Access granted=" + authorized + " for instance " + instanceid));
            }
            if (!authorized) {
                return new InsufficientPrivilegesResponse();
            }
            return super.invoke(invocation);
        }
        catch (PortalSecurityException e) {
            throw new InvocationException((Throwable)e);
        }
    }
}

