/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.security.impl.jacc;

import java.security.Policy;
import java.util.HashMap;
import java.util.Map;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.security.AuthorizationDomainRegistry;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.impl.jacc.JACCPortalAuthorizationManager;
import org.jboss.portal.security.impl.jacc.SecurityContext;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;
import org.jboss.security.jacc.DelegatingPolicy;
import org.jboss.security.jacc.SubjectPolicyContextHandler;

public class JACCPortalAuthorizationManagerFactory
extends AbstractJBossService
implements PortalAuthorizationManagerFactory {
    private AuthorizationDomainRegistry authorizationDomainRegistry;
    private final JACCPortalAuthorizationManager manager = new JACCPortalAuthorizationManager(this);
    final Map configuredRoles = new HashMap();
    private SecurityContext securityContext = null;

    public AuthorizationDomainRegistry getAuthorizationDomainRegistry() {
        return this.authorizationDomainRegistry;
    }

    public void setAuthorizationDomainRegistry(AuthorizationDomainRegistry authorizationDomainRegistry) {
        this.authorizationDomainRegistry = authorizationDomainRegistry;
    }

    public PortalAuthorizationManager getManager() {
        JACCPortalAuthorizationManager manager = new JACCPortalAuthorizationManager(this);
        if (this.securityContext == null) {
            this.securityContext = new SecurityContext();
        }
        manager.setSecurityContext(this.securityContext);
        return manager;
    }

    protected void startService() throws Exception {
        SubjectPolicyContextHandler handler = new SubjectPolicyContextHandler();
        PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)handler, (boolean)true);
        Policy policy = Policy.getPolicy();
        if (policy != null && policy instanceof DelegatingPolicy) {
            this.log.debug((Object)"Found existing delegating policy, configuring it with with PortalPermission");
            DelegatingPolicy dp = (DelegatingPolicy)policy;
            dp.setExternalPermissionTypes(new Class[]{PortalPermission.class});
        } else {
            this.log.debug((Object)"No existing delegating policy in place, adding one configured with the PortalPermission class");
            DelegatingPolicy dp = DelegatingPolicy.getInstance();
            dp.setExternalPermissionTypes(new Class[]{PortalPermission.class});
            Policy.setPolicy((Policy)dp);
            policy = dp;
        }
        policy.refresh();
        this.securityContext = new SecurityContext();
    }
}

