/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.jsr168;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.portal.common.i18n.ParentChildResourceBundle;
import org.jboss.portal.common.i18n.ResourceBundleFactory;
import org.jboss.portal.common.i18n.ResourceBundleManager;
import org.jboss.portal.common.util.EmptyResourceBundle;
import org.jboss.portal.portlet.impl.info.ContainerPortletInfo;
import org.jboss.portal.portlet.impl.jsr168.InlineBundle;

public class PortletResourceBundleFactory
implements ResourceBundleFactory {
    private final ResourceBundleManager bundleMgr;
    private final ResourceBundle infoBundle;

    public static ResourceBundleManager createResourceBundleManager(ResourceBundleManager bundleMgr, ContainerPortletInfo containerInfo) {
        if (bundleMgr == null) {
            throw new IllegalArgumentException("Need a non null classloader");
        }
        if (containerInfo == null) {
            throw new IllegalArgumentException("Need non null meta data");
        }
        PortletResourceBundleFactory factory = new PortletResourceBundleFactory(bundleMgr, containerInfo);
        ResourceBundleManager manager = new ResourceBundleManager((ResourceBundle)EmptyResourceBundle.INSTANCE, (ResourceBundleFactory)factory);
        return manager;
    }

    public PortletResourceBundleFactory(ResourceBundleManager bundleMgr, ContainerPortletInfo containerInfo) {
        if (bundleMgr == null) {
            throw new IllegalArgumentException("Need a non null classloader");
        }
        if (containerInfo == null) {
            throw new IllegalArgumentException("Need non null meta data");
        }
        this.bundleMgr = bundleMgr;
        this.infoBundle = new InlineBundle(containerInfo);
    }

    public ResourceBundle getBundle(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale cannot be null");
        }
        ResourceBundle bundle = this.bundleMgr.getResourceBundle(locale);
        bundle = bundle == null ? this.infoBundle : new ParentChildResourceBundle(this.infoBundle, bundle);
        return bundle;
    }
}

