/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.concurrent;

public class Valve {
    public static final int OPEN = 0;
    public static final int CLOSING = 1;
    public static final int CLOSED = 2;
    private static final String[] STATE_NAMES = new String[]{"OPEN", "CLOSING", "CLOSED"};
    protected final Object stateLock = new Object();
    protected int state;
    protected int invocations = 0;

    public Valve() {
        this(2);
    }

    protected Valve(int state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeInvocation() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) {
                return false;
            }
            ++this.invocations;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInvocation() {
        Object object = this.stateLock;
        synchronized (object) {
            --this.invocations;
            this.stateLock.notifyAll();
        }
    }

    public int getState() {
        return this.state;
    }

    public int getInvocations() {
        return this.invocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 2) {
                throw new IllegalStateException("Cannot invoke open() valve in state " + STATE_NAMES[this.state]);
            }
            this.state = 0;
        }
    }

    public void closing() throws IllegalStateException {
        this.closing(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closing(long millis) throws IllegalStateException {
        boolean interrupted = false;
        boolean empty = false;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                throw new IllegalStateException("Cannot invoke closing() valve in state " + STATE_NAMES[this.state]);
            }
            this.state = 1;
            long finished = -1L;
            if (millis > 0L) {
                finished = System.currentTimeMillis() + millis;
            }
            while (this.invocations > 0) {
                try {
                    if (finished == -1L) {
                        this.stateLock.wait();
                        continue;
                    }
                    long time = finished - System.currentTimeMillis();
                    if (time <= 0L) break;
                    this.stateLock.wait(time);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            empty = this.invocations == 0;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 1) {
                throw new IllegalStateException("Cannot invoke close() valve in state " + STATE_NAMES[this.state]);
            }
            this.state = 2;
        }
    }
}

