/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import org.jboss.portletbridge.io.FastBufferOutputStream;
import org.jboss.portletbridge.io.FastBufferWriter;

public class BufferedRenderResponseWrapper
implements RenderResponse {
    private final RenderResponse renderResponse;
    private FastBufferOutputStream fastBufferStream = null;
    private FastPrintWriter fastPrintWriter = null;

    public BufferedRenderResponseWrapper(RenderResponse renderResponse) {
        this.renderResponse = renderResponse;
    }

    public RenderResponse getResponse() {
        return this.renderResponse;
    }

    public void addProperty(String arg0, String arg1) {
        this.renderResponse.addProperty(arg0, arg1);
    }

    public void setProperty(String arg0, String arg1) {
        this.renderResponse.setProperty(arg0, arg1);
    }

    public void setTitle(String arg0) {
        this.renderResponse.setTitle(arg0);
    }

    public PortletURL createActionURL() {
        return this.renderResponse.createActionURL();
    }

    public PortletURL createRenderURL() {
        return this.renderResponse.createRenderURL();
    }

    public String encodeURL(String arg0) {
        return this.renderResponse.encodeURL(arg0);
    }

    public String getCharacterEncoding() {
        return this.renderResponse.getCharacterEncoding();
    }

    public String getContentType() {
        return this.renderResponse.getContentType();
    }

    public void setContentType(String arg0) {
        this.renderResponse.setContentType(arg0);
    }

    public Locale getLocale() {
        return this.renderResponse.getLocale();
    }

    public String getNamespace() {
        return this.renderResponse.getNamespace();
    }

    public OutputStream getPortletOutputStream() throws IOException {
        if (this.fastBufferStream == null) {
            this.fastBufferStream = new FastBufferOutputStream();
        }
        return this.fastBufferStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.fastPrintWriter == null) {
            this.fastPrintWriter = new FastPrintWriter();
        }
        return this.fastPrintWriter;
    }

    public boolean isCommitted() {
        return this.renderResponse.isCommitted();
    }

    private void resetBuffers() {
        if (this.fastBufferStream != null) {
            this.fastBufferStream.reset();
        }
        if (this.fastPrintWriter != null) {
            this.fastPrintWriter.reset();
        }
    }

    public void reset() {
        this.renderResponse.reset();
        this.resetBuffers();
    }

    public void resetBuffer() {
        this.renderResponse.resetBuffer();
        this.resetBuffers();
    }

    public void flushBuffer() throws IOException {
        this.renderResponse.flushBuffer();
    }

    public void setBufferSize(int arg0) {
        this.renderResponse.setBufferSize(arg0);
    }

    public int getBufferSize() {
        return this.renderResponse.getBufferSize();
    }

    public void writeBufferedData() throws IOException {
        if (this.fastBufferStream != null) {
            this.fastBufferStream.writeTo(this.renderResponse.getPortletOutputStream());
        } else if (this.fastPrintWriter != null) {
            this.fastPrintWriter.writeTo(this.renderResponse.getWriter());
        }
    }

    public boolean isUseWriter() {
        return this.fastBufferStream == null;
    }

    private static class FastPrintWriter
    extends PrintWriter {
        private final FastBufferWriter fastBufferWriter;

        public FastPrintWriter() {
            this(new FastBufferWriter());
        }

        private FastPrintWriter(FastBufferWriter writer) {
            super(writer);
            this.fastBufferWriter = writer;
        }

        public void reset() {
            this.fastBufferWriter.reset();
        }

        public void writeTo(Writer writer) throws IOException {
            this.fastBufferWriter.writeTo(writer);
        }
    }
}

