/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.admin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.ListDataModel;
import org.jboss.logging.Logger;
import org.jboss.portal.common.text.FastURLDecoder;
import org.jboss.portal.core.identity.ui.IdentityUIUser;
import org.jboss.portal.core.identity.ui.UIRole;
import org.jboss.portal.core.identity.ui.common.IdentityRoleBean;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;

public class RoleManagementBean {
    private String currentRole;
    private UIRole uiRole;
    private int page = 1;
    private String limit = "10";
    private String userNameFilter = new String();
    private ListDataModel roleList;
    private IdentityRoleBean identityRoleBean;
    private static final Logger log = Logger.getLogger(RoleManagementBean.class);
    private static final FastURLDecoder decoder = FastURLDecoder.getUTF8Instance();

    public IdentityRoleBean getIdentityRoleBean() {
        return this.identityRoleBean;
    }

    public void setIdentityRoleBean(IdentityRoleBean identityRoleBean) {
        this.identityRoleBean = identityRoleBean;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getUserNameFilter() {
        return this.userNameFilter;
    }

    public void setUserNameFilter(String userNameFilter) {
        this.userNameFilter = userNameFilter;
    }

    public UIRole getUiRole() {
        return this.uiRole;
    }

    public void setUiRole(UIRole uiRole) {
        this.uiRole = uiRole;
    }

    public ListDataModel getRoleList() {
        ArrayList<UIRole> list = new ArrayList<UIRole>();
        Set set = new HashSet();
        try {
            set = this.identityRoleBean.getRoleModule().findRoles();
        }
        catch (IdentityException e) {
            log.error((Object)"Error while performing roleModule.findRoles.", (Throwable)e);
        }
        for (Role role : set) {
            UIRole uiRole = new UIRole(role);
            list.add(uiRole);
        }
        this.roleList = new ListDataModel(list);
        return this.roleList;
    }

    public String viewRoleMembers() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = ctx.getExternalContext();
        Map params = ectx.getRequestParameterMap();
        String role = params.get("currentRole") != null ? decoder.encode((String)params.get("currentRole")) : null;
        this.currentRole = role != null ? role : this.currentRole;
        try {
            this.uiRole = this.identityRoleBean.getUIRole(this.currentRole);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", ctx.getViewRoot().getLocale());
            ctx.addMessage("status", new FacesMessage(bundle.getString("IDENTITY_MANAGEMENT_ERROR_ACTION_ROLE")));
            return "roleAdmin";
        }
        return "viewMembers";
    }

    public ListDataModel getRoleMembers() {
        Set members = new HashSet();
        ArrayList<IdentityUIUser> roleMembers = new ArrayList<IdentityUIUser>();
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (this.currentRole == null || this.currentRole.length() < 1) {
            return new ListDataModel(roleMembers);
        }
        try {
            int intLimit = Integer.valueOf(this.limit);
            int offset = this.page > 0 ? (this.page - 1) * intLimit : 0;
            int limit1 = intLimit + 1;
            members = this.identityRoleBean.getMembershipModule().findRoleMembers(this.currentRole, offset, limit1, this.userNameFilter);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", ctx.getViewRoot().getLocale());
            ctx.addMessage("status", new FacesMessage(bundle.getString("IDENTITY_MANAGEMENT_ERROR_ACTION_ROLE")));
        }
        if (members != null) {
            for (User user : members) {
                IdentityUIUser uiUser = new IdentityUIUser(user.getUserName());
                roleMembers.add(uiUser);
            }
        }
        return new ListDataModel(roleMembers);
    }

    public String deleteRole() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = ctx.getExternalContext();
        Map params = ectx.getRequestParameterMap();
        String string = this.currentRole = params.get("currentRole") != null ? decoder.encode((String)params.get("currentRole")) : null;
        if (this.currentRole != null) {
            try {
                this.uiRole = this.identityRoleBean.getUIRole(this.currentRole);
                return "deleteRole";
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
                ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", ctx.getViewRoot().getLocale());
                ctx.addMessage("status", new FacesMessage(bundle.getString("IDENTITY_MANAGEMENT_ERROR_ACTION_ROLE")));
                return "roleAdmin";
            }
        }
        return "roleAdmin";
    }

    public String confirmedDelete() {
        try {
            Role uRole = this.identityRoleBean.getRoleModule().findRoleByName(this.uiRole.getName());
            this.identityRoleBean.getRoleModule().removeRole(uRole.getId());
            this.roleList = null;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", FacesContext.getCurrentInstance().getViewRoot().getLocale());
            FacesContext.getCurrentInstance().addMessage("status", new FacesMessage(bundle.getString("IDENTITY_MANAGEMENT_ERROR_ACTION_ROLE")));
            return "roleAdmin";
        }
        return "roleAdmin";
    }

    public String nextPage() {
        ++this.page;
        return "viewMembers";
    }

    public String prevPage() {
        --this.page;
        return "viewMembers";
    }
}

