/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.command.mapper;

import java.util.ArrayList;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.command.mapper.AbstractURLFactory;
import org.jboss.portal.core.controller.command.mapper.DelegatingURLFactory;
import org.jboss.portal.core.controller.command.mapper.URLFactory;
import org.jboss.portal.core.controller.command.mapper.URLFactoryDelegate;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.server.ServerURL;

public class DelegatingURLFactoryService
extends AbstractURLFactory
implements DelegatingURLFactory {
    private URLFactory nextFactory;
    private ArrayList delegates = new ArrayList();

    public URLFactory getNextFactory() {
        return this.nextFactory;
    }

    public void setNextFactory(URLFactory nextFactory) {
        this.nextFactory = nextFactory;
    }

    public ServerURL doMapping(ControllerContext controllerContext, ServerInvocation invocation, ControllerCommand cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException("No null command accepted");
        }
        if (this.delegates != null) {
            for (int i = 0; i < this.delegates.size(); ++i) {
                URLFactory delegate = (URLFactory)this.delegates.get(i);
                ServerURL url = delegate.doMapping(controllerContext, invocation, cmd);
                if (url == null) continue;
                return url;
            }
        }
        if (this.nextFactory != null) {
            return this.nextFactory.doMapping(controllerContext, invocation, cmd);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(URLFactoryDelegate factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Command class name must not be null");
        }
        DelegatingURLFactoryService delegatingURLFactoryService = this;
        synchronized (delegatingURLFactoryService) {
            if (this.delegates.contains(factory)) {
                this.log.warn((Object)("Dual registration of URL factory " + factory));
            } else {
                ArrayList<URLFactoryDelegate> copy = new ArrayList<URLFactoryDelegate>(this.delegates);
                copy.add(factory);
                this.delegates = copy;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(URLFactoryDelegate factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Command class name must not be null");
        }
        DelegatingURLFactoryService delegatingURLFactoryService = this;
        synchronized (delegatingURLFactoryService) {
            if (this.delegates.contains(factory)) {
                this.log.warn((Object)("Unregistration of URL factory " + factory + " failed because it is not registered"));
            } else {
                ArrayList copy = new ArrayList(this.delegates);
                copy.remove(factory);
                this.delegates = copy;
            }
        }
    }
}

