/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.cms;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.editor.EditorService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.statistics.IStatisticsService;
import org.osivia.portal.api.user.IUserPreferencesService;
import org.osivia.portal.core.cms.spi.ICMSIntegration;

public class SessionListener
implements HttpSessionListener {
    public static final String ACTIVE_SESSION_SYNC = "activeSessionSync";
    public static long activeSessions = 0L;
    private final ICMSIntegration nuxeoService = (ICMSIntegration)Locator.findMBean(ICMSIntegration.class, (String)"osivia:service=NuxeoService");
    private final IStatisticsService statisticsService = (IStatisticsService)Locator.findMBean(IStatisticsService.class, (String)"osivia:service=StatisticsService");
    private final IUserPreferencesService preferencesService = (IUserPreferencesService)Locator.findMBean(IUserPreferencesService.class, (String)"osivia:service=UserPreferencesService");
    private final EditorService editorService = (EditorService)Locator.findMBean(EditorService.class, (String)"osivia:service=EditorService");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(HttpSessionEvent sessionEvent) {
        String string = ACTIVE_SESSION_SYNC;
        synchronized (ACTIVE_SESSION_SYNC) {
            ++activeSessions;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        String string = ACTIVE_SESSION_SYNC;
        synchronized (ACTIVE_SESSION_SYNC) {
            --activeSessions;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.nuxeoService.sessionDestroyed(sessionEvent);
            HttpSession httpSession = sessionEvent.getSession();
            try {
                this.statisticsService.aggregateUserStatistics(httpSession);
                this.preferencesService.updateUserPreferences(httpSession);
                this.editorService.clearAllTemporaryAttachedPictures(httpSession);
            }
            catch (PortalException portalException) {
                // empty catch block
            }
            return;
        }
    }
}

