/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.search.impl.jcr;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;
import org.jboss.portal.search.FederatedQuery;
import org.jboss.portal.search.Query;
import org.jboss.portal.search.QueryConversionException;
import org.jboss.portal.search.impl.AbstractQueryConverter;
import org.jboss.portal.search.impl.jcr.JCRQuery;

public class JCRQueryConverter
extends AbstractQueryConverter {
    public Query convert(FederatedQuery query) throws QueryConversionException {
        if (query == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        result.append("//*[");
        if (super.convert(query) != null) {
            result.append(((JCRQuery)super.convert(query)).getJcrQuery());
        }
        result.append("]");
        return new JCRQuery(result.toString());
    }

    public Query convertTermQuery(TermQuery query) {
        StringBuffer result = new StringBuffer();
        Term term = query.getTerm();
        result.append("jcr:contains(., '" + term.text() + "')");
        return new JCRQuery(result.toString());
    }

    public Query convertBooleanQuery(BooleanQuery query) throws QueryConversionException {
        BooleanClause[] clauses = query.getClauses();
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < clauses.length; ++i) {
            BooleanClause clause = clauses[i];
            if (!first) {
                result.append(", ");
            }
            if (clause.isProhibited()) continue;
            result.append(((JCRQuery)this.convert(clause.getQuery())).getJcrQuery());
            first = false;
        }
        return new JCRQuery(result.toString());
    }
}

