/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.render;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;
import org.displaytag.properties.TableProperties;

public abstract class TableWriterTemplate {
    public static final short GROUP_START = -2;
    public static final short GROUP_END = 5;
    public static final short GROUP_START_AND_END = 3;
    public static final short GROUP_NO_CHANGE = 0;
    protected static final int NO_RESET_GROUP = 42000;
    private static Log log = LogFactory.getLog((Class)TableWriterTemplate.class);
    private String id;
    int lowestEndedGroup;
    int lowestStartedGroup;

    public void writeTable(TableModel model, String id) throws JspException {
        try {
            boolean noItems;
            this.id = id;
            TableProperties properties = model.getProperties();
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.id + "] writeTable called for table [" + this.id + "]"));
            }
            boolean bl = noItems = model.getRowListPage().size() == 0;
            if (noItems && !properties.getEmptyListShowTable()) {
                this.writeEmptyListMessage(properties.getEmptyListMessage());
                return;
            }
            if (properties.getAddPagingBannerTop()) {
                this.writeTopBanner(model);
            }
            this.writeTableOpener(model);
            if (model.getCaption() != null) {
                this.writeCaption(model);
            }
            if (model.getProperties().getShowHeader()) {
                this.writeTableHeader(model);
            }
            if (model.getFooter() != null) {
                this.writePreBodyFooter(model);
            }
            this.writeTableBodyOpener(model);
            this.writeTableBody(model);
            this.writeTableBodyCloser(model);
            if (model.getFooter() != null) {
                this.writePostBodyFooter(model);
            }
            this.writeTableCloser(model);
            if (model.getTableDecorator() != null) {
                this.writeDecoratedTableFinish(model);
            }
            this.writeBottomBanner(model);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.id + "] writeTable end"));
            }
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    protected abstract void writeEmptyListMessage(String var1) throws Exception;

    protected abstract void writeTopBanner(TableModel var1) throws Exception;

    protected abstract void writeTableOpener(TableModel var1) throws Exception;

    protected abstract void writeCaption(TableModel var1) throws Exception;

    protected abstract void writeTableHeader(TableModel var1) throws Exception;

    protected abstract void writePreBodyFooter(TableModel var1) throws Exception;

    protected abstract void writeTableBodyOpener(TableModel var1) throws Exception;

    protected abstract void writeTableBodyCloser(TableModel var1) throws Exception;

    protected abstract void writePostBodyFooter(TableModel var1) throws Exception;

    protected abstract void writeTableCloser(TableModel var1) throws Exception;

    protected abstract void writeDecoratedTableFinish(TableModel var1) throws Exception;

    protected abstract void writeBottomBanner(TableModel var1) throws Exception;

    private void writeTableBody(TableModel model) throws Exception {
        RowIterator rowIterator = model.getRowIterator(false);
        TableDecorator tableDecorator = model.getTableDecorator();
        Row previousRow = null;
        Row currentRow = null;
        Row nextRow = null;
        HashMap previousRowValues = new HashMap(10);
        HashMap currentRowValues = new HashMap(10);
        HashMap<Integer, CellStruct> nextRowValues = new HashMap<Integer, CellStruct>(10);
        while (nextRow != null || rowIterator.hasNext()) {
            CellStruct struct;
            CellStruct struct2;
            Column column;
            ColumnIterator columnIterator;
            if (currentRow == null) {
                currentRow = rowIterator.next();
            } else {
                previousRow = currentRow;
                currentRow = nextRow;
            }
            if (previousRow != null) {
                previousRowValues.putAll(currentRowValues);
            }
            if (!nextRowValues.isEmpty()) {
                currentRowValues.putAll(nextRowValues);
            } else {
                columnIterator = currentRow.getColumnIterator(model.getHeaderCellList());
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" creating ColumnIterator on " + model.getHeaderCellList()));
                }
                while (columnIterator.hasNext()) {
                    column = columnIterator.nextColumn();
                    column.initialize();
                    struct2 = new CellStruct(column, column.getChoppedAndLinkedValue());
                    currentRowValues.put(new Integer(column.getHeaderCell().getColumnNumber()), struct2);
                }
            }
            nextRowValues.clear();
            Row row = nextRow = rowIterator.hasNext() ? rowIterator.next() : null;
            if (nextRow != null) {
                columnIterator = nextRow.getColumnIterator(model.getHeaderCellList());
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" creating ColumnIterator on " + model.getHeaderCellList()));
                }
                while (columnIterator.hasNext()) {
                    column = columnIterator.nextColumn();
                    column.initialize();
                    struct2 = new CellStruct(column, column.getChoppedAndLinkedValue());
                    nextRowValues.put(new Integer(column.getHeaderCell().getColumnNumber()), struct2);
                }
            }
            if (tableDecorator != null) {
                tableDecorator.initRow(currentRow.getObject(), currentRow.getRowNumber(), currentRow.getRowNumber() + rowIterator.getPageOffset());
            }
            Iterator headerCellsIter = model.getHeaderCellList().iterator();
            ArrayList<CellStruct> structsForRow = new ArrayList<CellStruct>(model.getHeaderCellList().size());
            this.lowestEndedGroup = 42000;
            this.lowestStartedGroup = 42000;
            while (headerCellsIter.hasNext()) {
                HeaderCell header = (HeaderCell)headerCellsIter.next();
                struct = (CellStruct)currentRowValues.get(new Integer(header.getColumnNumber()));
                struct.decoratedValue = struct.bodyValue;
                if (header.getGroup() != -1) {
                    CellStruct prior = (CellStruct)previousRowValues.get(new Integer(header.getColumnNumber()));
                    CellStruct next = (CellStruct)nextRowValues.get(new Integer(header.getColumnNumber()));
                    String priorBodyValue = prior != null ? prior.bodyValue : null;
                    String nextBodyValue = next != null ? next.bodyValue : null;
                    short groupingValue = this.groupColumns(struct.bodyValue, priorBodyValue, nextBodyValue, header.getGroup());
                    if (tableDecorator != null) {
                        switch (groupingValue) {
                            case -2: {
                                tableDecorator.startOfGroup(struct.bodyValue, header.getGroup());
                                break;
                            }
                            case 5: {
                                tableDecorator.endOfGroup(struct.bodyValue, header.getGroup());
                                break;
                            }
                            case 3: {
                                tableDecorator.startOfGroup(struct.bodyValue, header.getGroup());
                                tableDecorator.endOfGroup(struct.bodyValue, header.getGroup());
                                break;
                            }
                        }
                    }
                    if (tableDecorator != null) {
                        struct.decoratedValue = tableDecorator.displayGroupedValue(struct.bodyValue, groupingValue, header.getColumnNumber());
                    } else if (groupingValue == 5 || groupingValue == 0) {
                        struct.decoratedValue = "";
                    }
                }
                structsForRow.add(struct);
            }
            if (tableDecorator != null) {
                this.writeDecoratedRowStart(model);
            }
            this.writeRowOpener(currentRow);
            Iterator iterator = structsForRow.iterator();
            while (iterator.hasNext()) {
                struct = (CellStruct)iterator.next();
                this.writeColumnOpener(struct.column);
                this.writeColumnValue(struct.decoratedValue, struct.column);
                this.writeColumnCloser(struct.column);
            }
            if (model.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[" + this.id + "] table has no columns"));
                }
                this.writeRowWithNoColumns(currentRow.getObject().toString());
            }
            this.writeRowCloser(currentRow);
            if (model.getTableDecorator() == null) continue;
            this.writeDecoratedRowFinish(model);
        }
        if (model.getRowListPage().size() == 0) {
            this.writeEmptyListRowMessage(MessageFormat.format(model.getProperties().getEmptyListRowMessage(), new Integer(model.getNumberOfColumns())));
        }
    }

    protected abstract void writeDecoratedRowStart(TableModel var1) throws Exception;

    protected abstract void writeRowOpener(Row var1) throws Exception;

    protected abstract void writeColumnOpener(Column var1) throws Exception;

    protected abstract void writeColumnValue(Object var1, Column var2) throws Exception;

    protected abstract void writeColumnCloser(Column var1) throws Exception;

    protected abstract void writeRowWithNoColumns(String var1) throws Exception;

    protected abstract void writeRowCloser(Row var1) throws Exception;

    protected abstract void writeDecoratedRowFinish(TableModel var1) throws Exception;

    protected abstract void writeEmptyListRowMessage(String var1) throws Exception;

    protected short groupColumns(String value, String previous, String next, int currentGroup) {
        short groupingKey = 0;
        if (this.lowestEndedGroup < currentGroup) {
            groupingKey = (short)(groupingKey + 5);
        } else if (next == null || !ObjectUtils.equals((Object)value, (Object)next)) {
            groupingKey = (short)(groupingKey + 5);
            this.lowestEndedGroup = currentGroup;
        }
        if (this.lowestStartedGroup < currentGroup) {
            groupingKey = (short)(groupingKey - 2);
        } else if (previous == null || !ObjectUtils.equals((Object)value, (Object)previous)) {
            groupingKey = (short)(groupingKey - 2);
            this.lowestStartedGroup = currentGroup;
        }
        return groupingKey;
    }

    static class CellStruct {
        Column column;
        String bodyValue;
        String decoratedValue;

        public CellStruct(Column theColumn, String bodyValueParam) {
            this.column = theColumn;
            this.bodyValue = bodyValueParam;
        }
    }
}

