/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.i18n.ResourceBundleFactory;
import org.jboss.portal.common.i18n.ResourceBundleManager;
import org.jboss.portal.common.i18n.SimpleResourceBundleFactory;
import org.jboss.portal.core.admin.ui.ControlPropertyBean;
import org.jboss.portal.core.admin.ui.PortalObjectManagerBean;
import org.jboss.portal.core.admin.ui.PropertiesInfo;
import org.jboss.portal.core.admin.ui.PropertiesInfoBuilder;
import org.jboss.portal.core.admin.ui.PropertyBeanContainer;
import org.jboss.portal.core.model.portal.PortalObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlPropertiesBean
extends PropertyBeanContainer {
    private Map<Locale, List<SelectItem>> portalSelectItems;
    private Map<Locale, List<SelectItem>> pageSelectItems;
    private static final String BUNDLE_BASE_NAME = "Resource";
    final PortalObjectManagerBean pomgr;
    private static LocalizedString DISPLAY_THE_DEFAULT_ERROR_MESSAGE = null;
    private static LocalizedString REDIRECT_TO_THE_SPECIFIED_RESOURCE = null;
    private static LocalizedString REMOVE_THE_RESOURCE_FROM_PAGE = null;

    public ControlPropertiesBean(PortalObjectManagerBean pomgr) {
        this.pomgr = pomgr;
        ResourceBundleManager rbm = new ResourceBundleManager(null, (ResourceBundleFactory)new SimpleResourceBundleFactory(BUNDLE_BASE_NAME, PropertiesInfoBuilder.class.getClassLoader()));
        PortletRequest portletRequest = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        Enumeration locales = ((PortletConfig)portletRequest.getAttribute("javax.portlet.config")).getSupportedLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            rbm.getResourceBundle(locale);
        }
        DISPLAY_THE_DEFAULT_ERROR_MESSAGE = rbm.getLocalizedValue("DISPLAY_THE_DEFAULT_ERROR_MESSAGE", "Display the default error message");
        REDIRECT_TO_THE_SPECIFIED_RESOURCE = rbm.getLocalizedValue("REDIRECT_TO_THE_SPECIFIED_RESOURCE", "Redirect to the specified resource");
        REMOVE_THE_RESOURCE_FROM_PAGE = rbm.getLocalizedValue("REMOVE_THE_RESOURCE_FROM_PAGE", "Remove the resource from page");
        this.portalSelectItems = new HashMap<Locale, List<SelectItem>>();
        this.pageSelectItems = new HashMap<Locale, List<SelectItem>>();
    }

    public List<SelectItem> getPortalSelectItems() {
        Locale locale = FacesContext.getCurrentInstance().getExternalContext().getRequestLocale();
        if (this.portalSelectItems.get(locale) == null) {
            ArrayList<SelectItem> list = new ArrayList<SelectItem>();
            list.add(new SelectItem((Object)"ignore", DISPLAY_THE_DEFAULT_ERROR_MESSAGE.getString(locale, true)));
            list.add(new SelectItem((Object)"jsp", REDIRECT_TO_THE_SPECIFIED_RESOURCE.getString(locale, true)));
            this.portalSelectItems.put(locale, list);
        }
        return this.portalSelectItems.get(locale);
    }

    public List<SelectItem> getPageSelectItems() {
        Locale locale = FacesContext.getCurrentInstance().getExternalContext().getRequestLocale();
        if (this.pageSelectItems.get(locale) == null) {
            ArrayList<SelectItem> list = new ArrayList<SelectItem>();
            list.add(new SelectItem((Object)"ignore", DISPLAY_THE_DEFAULT_ERROR_MESSAGE.getString(locale, true)));
            list.add(new SelectItem((Object)"hide", REMOVE_THE_RESOURCE_FROM_PAGE.getString(locale, true)));
            list.add(new SelectItem((Object)"jsp", REDIRECT_TO_THE_SPECIFIED_RESOURCE.getString(locale, true)));
            this.pageSelectItems.put(locale, list);
        }
        return this.pageSelectItems.get(locale);
    }

    private ControlPropertyBean grabProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (!PropertiesInfo.isControlProperty(name)) {
            throw new IllegalStateException("trying to process non control property: " + name);
        }
        PortalObject object = this.pomgr.getSelectedObject();
        object = this.pomgr.getPortalObjectContainer().getObject(object.getId());
        PropertiesInfo info = new PropertiesInfo(object);
        boolean inheritable = object.getType() != 0;
        boolean inherited = !object.getDeclaredProperties().containsKey(name);
        String value = object.getProperty(name);
        return new ControlPropertyBean(this, info.getPropertyInfo(name), inherited, inheritable, value);
    }

    public ControlPropertyBean getPageControlAccessDenied() {
        return this.grabProperty("control.page.access_denied");
    }

    public ControlPropertyBean getPageControlUnavailable() {
        return this.grabProperty("control.page.unavailable");
    }

    public ControlPropertyBean getPageControlError() {
        return this.grabProperty("control.page.error");
    }

    public ControlPropertyBean getPageControlInternalError() {
        return this.grabProperty("control.page.internal_error");
    }

    public ControlPropertyBean getPageControlNotFound() {
        return this.grabProperty("control.page.not_found");
    }

    public ControlPropertyBean getPageControlResourceURI() {
        return this.grabProperty("control.page.resource_uri");
    }

    public ControlPropertyBean getPortalControlAccessDenied() {
        return this.grabProperty("control.portal.access_denied");
    }

    public ControlPropertyBean getPortalControlUnavailable() {
        return this.grabProperty("control.portal.unavailable");
    }

    public ControlPropertyBean getPortalControlError() {
        return this.grabProperty("control.portal.error");
    }

    public ControlPropertyBean getPortalControlInternalError() {
        return this.grabProperty("control.portal.internal_error");
    }

    public ControlPropertyBean getPortalControlNotFound() {
        return this.grabProperty("control.portal.not_found");
    }

    public ControlPropertyBean getPortalControlResourceURI() {
        return this.grabProperty("control.portal.resource_uri");
    }

    @Override
    public PortalObject getRelatedObject() {
        return this.pomgr.getSelectedObject();
    }
}

