/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.services.metadata;

import java.util.List;
import java.util.Map;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.info.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIComponentConfiguration {
    private String propertyRef;
    private String name;
    private List<String> validators;
    private String converter;
    private boolean required;
    private boolean readOnly;
    private Map<String, String> values;
    private String predefinedMapValues;
    private PropertyInfo propertyInfo;

    public String getPropertyRef() {
        return this.propertyRef;
    }

    public void setPropertyRef(String identifier) throws IdentityException {
        this.propertyRef = identifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValidator() {
        return this.validators.get(0);
    }

    public List<String> getValidators() {
        return this.validators;
    }

    public void setValidators(List<String> validators) {
        this.validators = validators;
    }

    public boolean isRequired() {
        return this.propertyInfo.getUsage().equals("mandatory") ? true : this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isReadOnly() {
        return this.propertyInfo.getAccessMode().equals("read-only") ? true : this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getConverter() {
        return this.converter;
    }

    public void setConverter(String converter) {
        this.converter = converter;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public void setValues(Map<String, String> values) {
        this.values = values;
    }

    public PropertyInfo getPropertyInfo() {
        return this.propertyInfo;
    }

    public void setPropertyInfo(PropertyInfo propertyInfo) {
        this.propertyInfo = propertyInfo;
    }

    public String getPredefinedMapValues() {
        return this.predefinedMapValues;
    }

    public void setPredefinedMapValues(String predefinedMapValues) {
        this.predefinedMapValues = predefinedMapValues;
    }

    public Class getPropertyClass() throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(this.propertyInfo.getType());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('@').append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{ name = ").append(this.name).append(',');
        builder.append(" reference = ").append(this.propertyRef).append('}');
        return builder.toString();
    }
}

