/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.bootstrap.basic;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.jboss.kernel.plugins.bootstrap.AbstractBootstrap;
import org.jboss.kernel.plugins.config.property.PropertyKernelConfig;
import org.jboss.kernel.spi.config.KernelConfig;

public class BasicBootstrap
extends AbstractBootstrap {
    public static void main(String[] args) throws Exception {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
    }

    public BasicBootstrap() throws Exception {
        Properties props = this.getSystemProperties();
        final PropertyKernelConfig config = new PropertyKernelConfig(props);
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                BasicBootstrap.this.setConfig(config);
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public BasicBootstrap(final KernelConfig config) throws Exception {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                BasicBootstrap.this.setConfig(config);
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    private Properties getSystemProperties() {
        if (System.getSecurityManager() == null) {
            return System.getProperties();
        }
        return (Properties)AccessController.doPrivileged(GetSystemProperties.instance);
    }

    private static class GetSystemProperties
    implements PrivilegedAction {
        private static GetSystemProperties instance = new GetSystemProperties();

        private GetSystemProperties() {
        }

        public Object run() {
            return System.getProperties();
        }
    }
}

