/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.auth;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;

public class SSOTestAuthenticationValve
extends ValveBase {
    private static final Logger log = Logger.getLogger(SSOTestAuthenticationValve.class);
    private String fileEncoding = System.getProperty("file.encoding");
    private String authType = "FORM";

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Request httpRequest = request;
        HttpSession session = httpRequest.getSession();
        request.setAttribute("ssoEnabled", (Object)"true");
        if (this.fileEncoding != null) {
            request.setCharacterEncoding(this.fileEncoding);
        }
        if (request.getParameter("ssouser") != null && session.getAttribute("ssouser") == null) {
            String userName = null;
            boolean skip = false;
            userName = request.getParameter("ssouser");
            if (!skip && userName == null) {
                skip = true;
            }
            if (!skip) {
                session.setAttribute("ssouser", (Object)userName);
                String user = userName;
                request.setAttribute("ssoSuccess", (Object)new Boolean(true));
                Principal principal = ((Context)this.container).getRealm().authenticate(user, (String)null);
                if (principal != null) {
                    this.register(request, response, principal, this.authType, user, null);
                }
            }
        }
        this.getNext().invoke(request, response);
    }

    private void register(Request request, Response response, Principal principal, String authType, String username, String password) {
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (session != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
    }
}

