/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.sm.file;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.mq.sm.file.DynamicStateManager;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class DynamicLoginModule
extends UsernamePasswordLoginModule {
    static final String DEFAULT_SM_NAME = "jboss.mq:service=StateManager";
    DynamicStateManager sm = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        try {
            String smName = (String)options.get("sm.objectname");
            if (smName == null) {
                smName = DEFAULT_SM_NAME;
            }
            ObjectName smObjectName = new ObjectName(smName);
            MBeanServer server = MBeanServerLocator.locateJBoss();
            this.sm = (DynamicStateManager)server.getAttribute(smObjectName, "Instance");
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to load DynamicSecurityManager", (Throwable)ex);
        }
    }

    public boolean login() throws LoginException {
        if (this.sm == null) {
            throw new LoginException("StateManager is null");
        }
        return super.login();
    }

    protected String getUsersPassword() throws LoginException {
        return "";
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean valid = false;
        try {
            valid = this.sm.validatePassword(this.getUsername(), inputPassword);
        }
        catch (Throwable e) {
            super.setValidateError(e);
        }
        return valid;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup userRoles = new SimpleGroup("Roles");
        String[] roles = null;
        try {
            roles = this.sm.getRoles(this.getUsername());
        }
        catch (Exception ex) {
            this.log.error((Object)("Could not get roleSets for user " + this.getUsername()), (Throwable)ex);
            throw new LoginException("Could not get roleSets for user");
        }
        if (roles != null) {
            for (int i = 0; i < roles.length; ++i) {
                userRoles.addMember((Principal)new SimplePrincipal(roles[i]));
            }
        }
        Group[] roleSets = new Group[]{userRoles};
        return roleSets;
    }
}

