/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.aspects.controller.node;

import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.api.PortalRuntimeContext;
import org.jboss.portal.api.node.PortalNode;
import org.jboss.portal.api.node.event.PageRenderEvent;
import org.jboss.portal.api.node.event.PortalNodeEvent;
import org.jboss.portal.api.node.event.WindowActionEvent;
import org.jboss.portal.api.node.event.WindowEvent;
import org.jboss.portal.api.node.event.WindowNavigationEvent;
import org.jboss.portal.api.node.event.WindowRenderEvent;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.common.util.LazyMap;
import org.jboss.portal.common.util.MapAccessor;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.core.aspects.controller.node.Navigation;
import org.jboss.portal.core.controller.CommandRedirectionException;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerInterceptor;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.event.PortalEventListenerRegistry;
import org.jboss.portal.core.impl.api.node.PortalNodeEventContextImpl;
import org.jboss.portal.core.impl.api.node.PortalNodeImpl;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.command.WindowCommand;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowActionCommand;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowRenderCommand;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.model.portal.command.render.RenderWindowCommand;
import org.jboss.portal.core.model.portal.navstate.WindowNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateKey;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.StateString;

public class EventBroadcasterInterceptor
extends ControllerInterceptor {
    private static Logger log = Logger.getLogger(EventBroadcasterInterceptor.class);
    private PortalEventListenerRegistry listenerRegistry;

    public PortalEventListenerRegistry getListenerRegistry() {
        return this.listenerRegistry;
    }

    public void setListenerRegistry(PortalEventListenerRegistry listenerRegistry) {
        this.listenerRegistry = listenerRegistry;
    }

    public ControllerResponse invoke(ControllerCommand cmd) throws Exception, InvocationException {
        ControllerCommand redirection;
        PortalNodeImpl node = Navigation.getCurrentNode();
        PortalNodeEvent nextEvent = null;
        PortalNodeEvent event = this.createEvent(cmd, node);
        if (event != null) {
            try {
                PortalRuntimeContext runtimeContext = Navigation.getPortalRuntimeContext();
                PortalNodeEventContextImpl nodeEventContext = new PortalNodeEventContextImpl(this.listenerRegistry, node, event, runtimeContext);
                nextEvent = nodeEventContext.dispatch();
            }
            catch (Exception e) {
                log.error((Object)("Error when dispatching pre event " + event), (Throwable)e);
            }
        }
        if (nextEvent != null && (redirection = this.createCommand(nextEvent)) != null) {
            throw new CommandRedirectionException(redirection);
        }
        return (ControllerResponse)cmd.invokeNext();
    }

    private ControllerCommand createCommand(PortalNodeEvent event) {
        if (event instanceof WindowEvent) {
            WindowEvent we = (WindowEvent)event;
            PortalNodeImpl nextNode = (PortalNodeImpl)we.getNode();
            PortalObjectId nodeRef = nextNode.getObjectId();
            Mode mode = we.getMode();
            WindowState windowState = we.getWindowState();
            if (event instanceof WindowActionEvent) {
                WindowActionEvent wae = (WindowActionEvent)event;
                Map params = wae.getParameters();
                if (params != null) {
                    return new InvokePortletWindowActionCommand(nodeRef, mode, windowState, null, (StateString)ParametersStateString.create((Map)params), null);
                }
            } else if (event instanceof WindowNavigationEvent) {
                WindowNavigationEvent wne = (WindowNavigationEvent)event;
                Map params = wne.getParameters();
                ParametersStateString state = params != null ? ParametersStateString.create((Map)params) : null;
                return new InvokePortletWindowRenderCommand(nodeRef, mode, windowState, (StateString)state);
            }
        }
        return null;
    }

    private PortalNodeEvent createEvent(ControllerCommand command, PortalNode node) {
        if (command instanceof WindowCommand) {
            WindowCommand wc = (WindowCommand)command;
            if (command instanceof InvokePortletWindowActionCommand) {
                InvokePortletWindowActionCommand iwac = (InvokePortletWindowActionCommand)wc;
                ParameterMap formParameters = iwac.getFormParameters();
                Map interactionParameters = null;
                if (iwac.getInteractionState() instanceof ParametersStateString) {
                    interactionParameters = ((ParametersStateString)iwac.getInteractionState()).getParameters();
                }
                Object actionParameters = interactionParameters != null ? (formParameters != null ? new ActionParameterMap(interactionParameters, (Map<String, String[]>)formParameters) : interactionParameters) : (formParameters != null ? formParameters : new ParameterMap());
                WindowActionEvent action = new WindowActionEvent(node);
                action.setMode(iwac.getMode());
                action.setWindowState(iwac.getWindowState());
                action.setParameters(actionParameters);
                return action;
            }
            if (command instanceof InvokePortletWindowRenderCommand) {
                InvokePortletWindowRenderCommand iwrc = (InvokePortletWindowRenderCommand)wc;
                WindowNavigationEvent event = new WindowNavigationEvent(node);
                event.setMode(iwrc.getMode());
                event.setWindowState(iwrc.getWindowState());
                StateString navigationalState = iwrc.getNavigationalState();
                if (navigationalState instanceof ParametersStateString) {
                    Map params = ((ParametersStateString)navigationalState).getParameters();
                    event.setParameters(params);
                }
                return event;
            }
            if (command instanceof RenderWindowCommand) {
                WindowRenderEvent event = new WindowRenderEvent(node);
                RenderWindowCommand rwc = (RenderWindowCommand)command;
                NavigationalStateKey key = new NavigationalStateKey(WindowNavigationalState.class, rwc.getTargetId());
                WindowNavigationalState navstate = (WindowNavigationalState)command.getControllerContext().getAttribute(ControllerCommand.NAVIGATIONAL_STATE_SCOPE, key);
                if (navstate != null) {
                    event.setMode(navstate.getMode());
                    event.setWindowState(navstate.getWindowState());
                    StateString parametersState = navstate.getContentState();
                    if (parametersState instanceof ParametersStateString) {
                        Map params = ((ParametersStateString)parametersState).getParameters();
                        event.setParameters(params);
                    }
                }
                return event;
            }
        } else if (command instanceof RenderPageCommand) {
            return new PageRenderEvent(node);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionParameterMap
    extends LazyMap<String, String[]> {
        public ActionParameterMap(final Map<String, String[]> interactionParams, final Map<String, String[]> formParams) {
            super((MapAccessor)new MapAccessor<String, String[]>(){
                private ParameterMap params;

                public Map<String, String[]> getMap(boolean writable) {
                    if (this.params == null) {
                        this.params = new ParameterMap(interactionParams);
                        this.params.append(formParams);
                    }
                    return this.params;
                }
            });
        }
    }
}

