/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.portlet;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.FixMe;
import org.jboss.portal.common.NotYetImplemented;
import org.jboss.portal.common.util.MultiValuedPropertyMap;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.command.response.ErrorResponse;
import org.jboss.portal.core.controller.command.response.RedirectionResponse;
import org.jboss.portal.core.controller.command.response.StreamContentResponse;
import org.jboss.portal.core.controller.command.response.UnavailableResourceResponse;
import org.jboss.portal.core.controller.portlet.SignOutResponse;
import org.jboss.portal.core.model.instance.command.response.PortletInstanceActionResponse;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.command.response.PortletWindowActionResponse;
import org.jboss.portal.core.model.portal.navstate.PageNavigationalState;
import org.jboss.portal.portlet.NoSuchPortletException;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.info.ParameterInfo;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.portlet.invocation.response.ContentResponse;
import org.jboss.portal.portlet.invocation.response.HTTPRedirectionResponse;
import org.jboss.portal.portlet.invocation.response.InsufficientPrivilegesResponse;
import org.jboss.portal.portlet.invocation.response.InsufficientTransportGuaranteeResponse;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.invocation.response.ResponseProperties;
import org.jboss.portal.portlet.invocation.response.SecurityErrorResponse;
import org.jboss.portal.portlet.invocation.response.UpdateNavigationalStateResponse;

public class ControllerResponseFactory {
    public static ControllerResponse createResponse(PortletInvokerException e) {
        if (e instanceof NoSuchPortletException) {
            return new UnavailableResourceResponse(((NoSuchPortletException)((Object)e)).getPortletId(), false);
        }
        return new ErrorResponse(e, false);
    }

    public static ControllerResponse createActionResponse(PortalObjectId targetId, PortletInvocationResponse response, PortletInfo portletInfo, PageNavigationalState pns) {
        if (response instanceof UpdateNavigationalStateResponse) {
            UpdateNavigationalStateResponse renderResult = (UpdateNavigationalStateResponse)response;
            Mode mode = renderResult.getMode();
            WindowState windowState = renderResult.getWindowState();
            StateString state = renderResult.getNavigationalState();
            if (state instanceof ParametersStateString) {
                Map stringMap = ((ParametersStateString)state).getParameters();
                HashMap<String, String[]> parameters = new HashMap<String, String[]>(stringMap);
                parameters.putAll(renderResult.getPublicNavigationalStateUpdates());
                if (pns != null) {
                    for (ParameterInfo parameterInfo : portletInfo.getNavigation().getPublicParameters()) {
                        String key = parameterInfo.getId();
                        String[] values = pns.getParameter(parameterInfo.getName());
                        if (values == null) continue;
                        parameters.put(key, values);
                    }
                }
                state = ParametersStateString.create(parameters);
            }
            return new PortletWindowActionResponse(targetId, windowState, mode, state);
        }
        return ControllerResponseFactory.createResponse(response);
    }

    public static ControllerResponse createActionResponse(String instanceId, PortletInvocationResponse response) {
        if (response instanceof UpdateNavigationalStateResponse) {
            UpdateNavigationalStateResponse renderResult = (UpdateNavigationalStateResponse)response;
            return new PortletInstanceActionResponse(instanceId, null, null, renderResult.getNavigationalState());
        }
        return ControllerResponseFactory.createResponse(response);
    }

    private static ControllerResponse createResponse(PortletInvocationResponse response) {
        if (response instanceof HTTPRedirectionResponse) {
            HTTPRedirectionResponse redirection = (HTTPRedirectionResponse)response;
            String location = redirection.getLocation();
            return new RedirectionResponse(location);
        }
        if (response instanceof InsufficientTransportGuaranteeResponse) {
            return new org.jboss.portal.core.controller.command.response.SecurityErrorResponse(1, false);
        }
        if (response instanceof InsufficientPrivilegesResponse) {
            return new org.jboss.portal.core.controller.command.response.SecurityErrorResponse(0, false);
        }
        if (response instanceof SignOutResponse) {
            return new org.jboss.portal.core.controller.command.response.SignOutResponse(((SignOutResponse)response).getLocation());
        }
        if (response instanceof org.jboss.portal.portlet.invocation.response.ErrorResponse) {
            return new ErrorResponse(((org.jboss.portal.portlet.invocation.response.ErrorResponse)response).getCause(), false);
        }
        if (response instanceof SecurityErrorResponse) {
            SecurityErrorResponse ser = (SecurityErrorResponse)response;
            return new org.jboss.portal.core.controller.command.response.SecurityErrorResponse(ser.getThrowable(), 0, false);
        }
        if (response instanceof ContentResponse) {
            ContentResponse contentResponse = (ContentResponse)response;
            int type = contentResponse.getType();
            if (type == 0) {
                throw new NotYetImplemented("handling of empty ContentResponse");
            }
            String contentType = contentResponse.getContentType();
            ResponseProperties properties = contentResponse.getProperties();
            MultiValuedPropertyMap headers = null;
            if (properties != null) {
                headers = properties.getTransportHeaders();
            }
            if (type == 2) {
                return new StreamContentResponse(contentType, (MultiValuedPropertyMap<String>)headers, new ByteArrayInputStream(contentResponse.getBytes()));
            }
            return new StreamContentResponse(contentType, (MultiValuedPropertyMap<String>)headers, (Reader)new StringReader(contentResponse.getChars()));
        }
        throw new FixMe("Undefined response mapping for " + response);
    }
}

