/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.cache;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.jboss.portal.core.identity.cache.IdentityCacheService;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.identity.ldap.LDAPRoleImpl;
import org.jboss.portal.identity.ldap.LDAPRoleModule;

public class CachedLDAPRoleModuleWrapper
extends LDAPRoleModule
implements RoleModule {
    private LDAPRoleModule ldapRoleModule;
    private IdentityCacheService cacheService;

    public CachedLDAPRoleModuleWrapper(LDAPRoleModule ldapRoleModule, IdentityCacheService cacheService) {
        this.ldapRoleModule = ldapRoleModule;
        this.cacheService = cacheService;
    }

    public Role findRoleByName(String name) throws IdentityException, IllegalArgumentException {
        Role role = this.cacheService.findRoleByName(name);
        if (role != null) {
            return role;
        }
        return this.ldapRoleModule.findRoleByName(name);
    }

    public Set findRolesByNames(String[] names) throws IdentityException, IllegalArgumentException {
        Set<Object> roles = new HashSet<Role>();
        for (String name : names) {
            Role role = this.cacheService.findRoleByName(name);
            if (role == null) {
                roles = this.ldapRoleModule.findRolesByNames(names);
                break;
            }
            roles.add(role);
        }
        return roles;
    }

    public Role findRoleById(Object id) throws IdentityException, IllegalArgumentException {
        Role role = this.cacheService.findRoleById(id);
        if (role != null) {
            return role;
        }
        return this.ldapRoleModule.findRoleById(id);
    }

    public Role findRoleById(String id) throws IdentityException, IllegalArgumentException {
        return this.findRoleById((Object)id);
    }

    public Role createRole(String name, String displayName) throws IdentityException, IllegalArgumentException {
        Role role = this.ldapRoleModule.createRole(name, displayName);
        this.cacheService.storeRole(role);
        return role;
    }

    public void removeRole(Object id) throws IdentityException, IllegalArgumentException {
        this.ldapRoleModule.removeRole(id);
        Role role = this.cacheService.findRoleById(id);
        if (role != null) {
            this.cacheService.invalidateRole(role);
        }
    }

    public int getRolesCount() throws IdentityException {
        return this.ldapRoleModule.getRolesCount();
    }

    public Set findRoles() throws IdentityException {
        Set roles = this.cacheService.getRoles();
        if (roles != null) {
            return roles;
        }
        roles = this.ldapRoleModule.findRoles();
        this.cacheService.storeRoles(roles);
        return this.ldapRoleModule.findRoles();
    }

    public List searchRoles(String filter, Object[] filterArgs) throws NamingException, IdentityException {
        return this.ldapRoleModule.searchRoles(filter, filterArgs);
    }

    public void updateDisplayName(LDAPRoleImpl ldapr, String name) throws IdentityException {
        this.ldapRoleModule.updateDisplayName(ldapr, name);
        this.cacheService.invalidateRole((Role)ldapr);
    }

    public LDAPRoleImpl createRoleInstance(Attributes attrs, String dn) throws IdentityException {
        return this.ldapRoleModule.createRoleInstance(attrs, dn);
    }

    public Role findRoleByDN(String dn) throws IdentityException, IllegalArgumentException {
        return this.ldapRoleModule.findRoleByDN(dn);
    }
}

