/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.net.media.MediaType;
import org.jboss.portal.common.util.MultiValuedPropertyMap;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.command.response.ErrorResponse;
import org.jboss.portal.core.controller.command.response.SecurityErrorResponse;
import org.jboss.portal.core.controller.command.response.UnavailableResourceResponse;
import org.jboss.portal.core.impl.model.content.InternalContentProviderRegistry;
import org.jboss.portal.core.model.content.Content;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.ContentProvider;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstancePermission;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.response.MarkupResponse;
import org.jboss.portal.core.model.portal.content.ContentRenderer;
import org.jboss.portal.core.model.portal.content.ContentRendererContext;
import org.jboss.portal.core.model.portal.content.WindowRendition;
import org.jboss.portal.portlet.NoSuchPortletException;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;
import org.jboss.portal.portlet.info.CapabilitiesInfo;
import org.jboss.portal.portlet.info.ModeInfo;
import org.jboss.portal.portlet.info.WindowStateInfo;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.RenderInvocation;
import org.jboss.portal.portlet.invocation.response.FragmentResponse;
import org.jboss.portal.portlet.invocation.response.InsufficientPrivilegesResponse;
import org.jboss.portal.portlet.invocation.response.InsufficientTransportGuaranteeResponse;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.invocation.response.ResponseProperties;
import org.jboss.portal.portlet.invocation.response.UnavailableResponse;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;
import org.jboss.portal.theme.impl.render.dynamic.DynaRenderOptions;

public abstract class InternalContentProvider
implements ContentRenderer {
    private final Logger log = Logger.getLogger(this.getClass());
    private InternalContentProviderRegistry registry;
    private String contentType;
    private PortalAuthorizationManagerFactory pamf;
    ContentType registeredContentType;
    ContentProvider contentProvider;

    public PortalAuthorizationManagerFactory getPortalAuthorizationManagerFactory() {
        return this.pamf;
    }

    public void setPortalAuthorizationManagerFactory(PortalAuthorizationManagerFactory portalAuthorizationManagerFactory) {
        this.pamf = portalAuthorizationManagerFactory;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ContentType getRegisteredContentType() {
        return this.registeredContentType;
    }

    public InternalContentProviderRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(InternalContentProviderRegistry registry) {
        this.registry = registry;
    }

    public void start() throws Exception {
        this.registeredContentType = ContentType.create(this.contentType);
        this.contentProvider = this.createProvider();
        this.registry.registerContentProvider(this);
    }

    protected abstract ContentProvider createProvider();

    public void stop() {
        if (this.registeredContentType != null) {
            this.registry.unregisterContentProvider(this.registeredContentType);
        }
    }

    protected abstract Instance getPortletInstance(ContentRendererContext var1);

    public WindowRendition renderWindow(ContentRendererContext rendererContext) {
        ControllerResponse cr;
        PortletInvocationResponse response;
        Window window = rendererContext.getWindow();
        Portal portal = null;
        for (PortalObject current = window; current != null; current = current.getParent()) {
            if (current.getType() != 1) continue;
            portal = (Portal)current;
            break;
        }
        HashMap<String, String> windowProps = new HashMap<String, String>(window.getProperties());
        try {
            Instance portletInstance = this.getPortletInstance(rendererContext);
            if (portletInstance == null) {
                this.log.debug((Object)("Portlet associated with " + rendererContext.getWindow() + " window could not be found!"));
                throw new NoSuchPortletException("Portlet associated with " + rendererContext.getWindow() + " window could not be found!");
            }
            portletInstance.getPortlet();
        }
        catch (PortletInvokerException e) {
            ControllerResponse cr2;
            if (e instanceof NoSuchPortletException) {
                cr2 = new UnavailableResourceResponse(((NoSuchPortletException)((Object)e)).getPortletId(), false);
            } else {
                this.log.error((Object)"Portlet invoker exception during portlet window rendering", (Throwable)e);
                cr2 = new ErrorResponse(e, false);
            }
            return new WindowRendition(windowProps, WindowState.NORMAL, Mode.VIEW, null, null, cr2);
        }
        PortletWindowNavigationalState windowNS = rendererContext.getPortletNavigationalState();
        Mode mode = windowNS.getMode();
        WindowState windowState = windowNS.getWindowState();
        Instance instance = this.getPortletInstance(rendererContext);
        if (instance == null) {
            String ref = null;
            Content content = window.getContent();
            if (content != null) {
                ref = content.getURI();
            }
            if (ref == null) {
                ref = window.getId().toString();
            }
            UnavailableResourceResponse cr3 = new UnavailableResourceResponse(ref, false);
            return new WindowRendition(windowProps, windowState, mode, Collections.singletonList(windowState), Collections.singletonList(mode), cr3);
        }
        RenderInvocation invocation = rendererContext.createRenderInvocation(new PortletWindowNavigationalState(windowNS.getPortletNavigationalState(), mode, windowState));
        List supportedWindowStates = Collections.emptyList();
        List supportedModes = Collections.emptyList();
        try {
            Portlet portlet = instance.getPortlet();
            CapabilitiesInfo capabilitiesInfo = portlet.getInfo().getCapabilities();
            MediaType mediaType = invocation.getContext().getMarkupInfo().getMediaType();
            Set windowStatesInfo = capabilitiesInfo.getWindowStates(mediaType);
            supportedWindowStates = new ArrayList(windowStatesInfo.size());
            for (WindowStateInfo windowStateInfo : windowStatesInfo) {
                WindowState tmp = windowStateInfo.getWindowState();
                if (!portal.getSupportedWindowStates().contains(tmp)) continue;
                supportedWindowStates.add(tmp);
            }
            Set modesInfo = capabilitiesInfo.getModes(mediaType);
            supportedModes = new ArrayList(modesInfo.size());
            for (ModeInfo modeInfo : modesInfo) {
                Mode tmp = modeInfo.getMode();
                if (!portal.getSupportedModes().contains(tmp)) continue;
                supportedModes.add(tmp);
            }
            if (rendererContext.getUser() == null) {
                supportedModes.remove(Mode.EDIT);
            }
            InstancePermission perm = new InstancePermission(instance.getId(), "admin");
            PortalAuthorizationManager pam = this.pamf.getManager();
            boolean authorized = pam.checkPermission((PortalPermission)perm);
            if (!authorized) {
                supportedModes.remove(Mode.ADMIN);
            }
            response = instance.invoke((PortletInvocation)invocation);
        }
        catch (Exception e) {
            ControllerResponse cr4;
            if (e instanceof NoSuchPortletException) {
                cr4 = new UnavailableResourceResponse(((NoSuchPortletException)((Object)e)).getPortletId(), false);
            } else {
                this.log.error((Object)"Portlet invoker exception during portlet window rendering", (Throwable)e);
                cr4 = new ErrorResponse(e, false);
            }
            return new WindowRendition(windowProps, windowState, mode, supportedWindowStates, supportedModes, cr4);
        }
        if (response instanceof FragmentResponse) {
            FragmentResponse fragment = (FragmentResponse)response;
            String windowTitle = fragment.getTitle();
            if (windowTitle == null) {
                windowTitle = window.getName();
            }
            List headElements = null;
            ResponseProperties properties = fragment.getProperties();
            if (properties != null) {
                MultiValuedPropertyMap headers = properties.getMarkupHeaders();
                headElements = headers.getValues("javax.portlet.markup.head.element");
                MultiValuedPropertyMap transport = properties.getTransportHeaders();
                String partialRefreshValue = (String)transport.getValue("partialRefresh");
                Boolean partialRefresh = Boolean.parseBoolean(partialRefreshValue);
                if (partialRefresh != null && Boolean.FALSE.equals(partialRefresh)) {
                    DynaRenderOptions options = DynaRenderOptions.getOptions(null, (Boolean)partialRefresh);
                    options.setOptions(windowProps);
                }
            }
            String contentChars = WindowState.MINIMIZED == windowNS.getWindowState() ? "" : fragment.getChars();
            cr = new MarkupResponse(windowTitle, contentChars, headElements);
        } else if (response instanceof org.jboss.portal.portlet.invocation.response.ErrorResponse) {
            cr = new ErrorResponse(((org.jboss.portal.portlet.invocation.response.ErrorResponse)response).getCause(), false);
        } else if (response instanceof UnavailableResponse) {
            cr = new UnavailableResourceResponse(instance.getId(), false);
        } else if (response instanceof InsufficientPrivilegesResponse) {
            cr = new SecurityErrorResponse(0, false);
        } else if (response instanceof InsufficientTransportGuaranteeResponse) {
            cr = new SecurityErrorResponse(1, false);
        } else {
            return null;
        }
        return new WindowRendition(windowProps, windowState, mode, supportedWindowStates, supportedModes, cr);
    }

    private String getPortletName(Portlet portlet) throws PortletInvokerException {
        LocalizedString displayName = portlet.getInfo().getMeta().getMetaValue("display-name");
        String name = displayName == null ? portlet.getContext().getId() : displayName.getDefaultString();
        return "'" + name + "'";
    }
}

