/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal;

import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.command.mapper.URLFactoryDelegate;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.command.PortalObjectCommand;
import org.jboss.portal.core.model.portal.command.action.ImportPageToDashboardCommand;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowActionCommand;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowCommand;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowResourceCommand;
import org.jboss.portal.core.model.portal.command.action.InvokeWindowCommand;
import org.jboss.portal.core.model.portal.command.mapping.PortalObjectPathMapper;
import org.jboss.portal.core.model.portal.command.view.ViewPageCommand;
import org.jboss.portal.core.model.portal.command.view.ViewPortalCommand;
import org.jboss.portal.core.portlet.PortletRequestEncoder;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.cache.CacheLevel;
import org.jboss.portal.server.AbstractServerURL;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.server.ServerURL;

public class PortalObjectURLFactory
extends URLFactoryDelegate {
    private String path;
    private String namespace;
    private PortalObjectPathMapper mapper;
    private String effectiveNamespace;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public PortalObjectPathMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(PortalObjectPathMapper mapper) {
        this.mapper = mapper;
    }

    protected void startService() throws Exception {
        super.startService();
        this.effectiveNamespace = this.namespace == null ? "" : this.namespace;
    }

    public ServerURL doMapping(ControllerContext controllerContext, ServerInvocation invocation, ControllerCommand cmd) {
        PortalObjectCommand poc;
        PortalObjectId targetId;
        String targetNamespace;
        if (cmd == null) {
            throw new IllegalArgumentException("No null command accepted");
        }
        if (cmd instanceof PortalObjectCommand && this.effectiveNamespace.equals(targetNamespace = (targetId = (poc = (PortalObjectCommand)cmd).getTargetId()).getNamespace())) {
            AbstractServerURL url = this.getBaseURL(targetId);
            if (cmd instanceof ViewPageCommand) {
                ViewPageCommand vpCmd = (ViewPageCommand)cmd;
                Map<String, String[]> parameters = vpCmd.getParameters();
                url.getParameterMap().putAll(parameters);
            } else if (!(cmd instanceof ViewPortalCommand)) {
                if (cmd instanceof InvokeWindowCommand) {
                    InvokeWindowCommand iwCmd = (InvokeWindowCommand)cmd;
                    PortletRequestEncoder encoder = new PortletRequestEncoder(url.getParameterMap());
                    if (cmd instanceof InvokePortletWindowCommand) {
                        InvokePortletWindowCommand ipwCmd = (InvokePortletWindowCommand)iwCmd;
                        Mode mode = ipwCmd.getMode();
                        WindowState windowState = ipwCmd.getWindowState();
                        StateString navigationalState = ((InvokePortletWindowCommand)iwCmd).getNavigationalState();
                        if (iwCmd instanceof InvokePortletWindowActionCommand) {
                            StateString interactionState = ((InvokePortletWindowActionCommand)iwCmd).getInteractionState();
                            encoder.encodeAction(navigationalState, interactionState, mode, windowState);
                        } else {
                            encoder.encodeRender(navigationalState, mode, windowState);
                        }
                    } else {
                        InvokePortletWindowResourceCommand ipwrCmd = (InvokePortletWindowResourceCommand)iwCmd;
                        StateString resourceState = ipwrCmd.getResourceState();
                        String resourceId = ipwrCmd.getResourceId();
                        CacheLevel cacheability = ipwrCmd.getCacheability();
                        encoder.encodeResource(cacheability, resourceId, resourceState);
                    }
                } else if (cmd instanceof ImportPageToDashboardCommand) {
                    url.setParameterValue("action", "import");
                }
            }
            return url;
        }
        return null;
    }

    private AbstractServerURL getBaseURL(PortalObjectId id) {
        StringBuffer buffer = new StringBuffer();
        if (this.path != null && this.path.length() > 0) {
            buffer.append(this.path);
        }
        this.mapper.appendPath(buffer, id);
        AbstractServerURL asu = new AbstractServerURL();
        asu.setPortalRequestPath(buffer.toString());
        return asu;
    }
}

