/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.theme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowRenderCommand;
import org.jboss.portal.core.model.portal.command.response.MarkupResponse;
import org.jboss.portal.core.model.portal.content.WindowRendition;
import org.jboss.portal.server.ServerInvocationContext;
import org.jboss.portal.server.request.URLContext;
import org.jboss.portal.server.request.URLFormat;
import org.jboss.portal.theme.page.WindowContext;
import org.jboss.portal.theme.page.WindowResult;

public class WindowContextFactory {
    private final ControllerContext context;

    public WindowContextFactory(ControllerContext context) {
        this.context = context;
    }

    public WindowContext createWindowContext(Window window, WindowRendition context) {
        HashMap actionMap = new HashMap();
        this.addModeActions(window, actionMap, context.getMode(), context.getSupportedModes());
        this.addWindowStateActions(window, actionMap, context.getWindowState(), context.getSupportedWindowStates());
        MarkupResponse markup = (MarkupResponse)context.getControllerResponse();
        String region = window.getDeclaredProperty("theme.region");
        if (this.context.getAttribute(ControllerCommand.PRINCIPAL_SCOPE, "osivia.popupModeWindowID") != null) {
            region = "popup";
        }
        String order = window.getDeclaredProperty("theme.order");
        WindowResult windowResult = new WindowResult(markup.getTitle(), markup.getContent(), actionMap, context.getProperties(), markup.getHeaderContent(), context.getWindowState(), context.getMode());
        return new WindowContext(window.getId().toString(PortalObjectPath.SAFEST_FORMAT), region, order, windowResult);
    }

    protected final void addWindowStateActions(Window window, Map actionMap, WindowState currentWindowState, List supportedWindowStates) {
        ArrayList<WindowResult.Action> windowStates = new ArrayList<WindowResult.Action>(supportedWindowStates.size());
        for (WindowState windowState : supportedWindowStates) {
            String url = this.createUpdateNavigationalStateURL(window, null, windowState);
            boolean disabled = windowState.equals((Object)currentWindowState);
            WindowResult.Action action = new WindowResult.Action(windowState.toString(), "window_state", url, !disabled);
            windowStates.add(action);
        }
        actionMap.put("windowstate", windowStates);
    }

    protected final void addModeActions(Window window, Map actionMap, Mode currentMode, List supportedModes) {
        ArrayList<WindowResult.Action> modes = new ArrayList<WindowResult.Action>(supportedModes.size());
        for (Mode mode : supportedModes) {
            String url = this.createUpdateNavigationalStateURL(window, mode, null);
            boolean disabled = mode.equals((Object)currentMode);
            WindowResult.Action action = new WindowResult.Action(mode.toString(), "mode", url, !disabled);
            modes.add(action);
        }
        actionMap.put("mode", modes);
    }

    protected final String createUpdateNavigationalStateURL(Window window, Mode mode, WindowState windowState) {
        InvokePortletWindowRenderCommand cmd = new InvokePortletWindowRenderCommand(window.getId(), mode, windowState);
        ServerInvocationContext serverContext = this.context.getServerInvocation().getServerContext();
        boolean secure = serverContext.getURLContext().isSecure();
        boolean authenticated = serverContext.getURLContext().isAuthenticated();
        URLContext urlContext = URLContext.newInstance((boolean)secure, (boolean)authenticated);
        return this.context.renderURL(cmd, urlContext, URLFormat.newInstance((boolean)true, (boolean)true));
    }
}

