/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.jems.as.system;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.apache.log4j.Logger;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.modelmbean.ModelMBeanInvoker;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.InvocationContext;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.portal.common.mx.JavaBeanModelMBeanBuilder;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.jems.as.system.JMXConstants;
import org.jboss.portal.jems.as.system.POJOInjection;
import org.jboss.portal.jems.as.system.POJOInjector;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public class JBossServiceModelMBean
extends ModelMBeanInvoker {
    private static final ModelMBeanInfo serviceMixinInfo;
    private static final Logger log;
    public static final String PORTAL_KERNEL_NO_PROXIES = "portal.kernel.no_proxies";
    private final boolean replaceProxies;
    private final ServiceMixin serviceMixin;
    private final POJOInjector injector;
    private final boolean createExists;
    private final boolean startExists;
    private final boolean stopExists;
    private final boolean destroyExists;
    private final boolean getStateExists;
    private final boolean getStateStringExists;
    private final boolean getManagedResourceExists;

    public JBossServiceModelMBean(Object resource) throws MBeanException {
        this(resource, null, null);
    }

    public JBossServiceModelMBean(Object resource, Element config, String version) throws MBeanException {
        try {
            this.setManagedResource(resource, "ObjectReference");
            boolean pojo = !(resource instanceof ServiceMBeanSupport);
            ModelMBeanInfo info = JavaBeanModelMBeanBuilder.build(resource.getClass(), pojo ? Object.class : ServiceMBeanSupport.class);
            this.replaceProxies = "true".equals(System.getProperty(PORTAL_KERNEL_NO_PROXIES, "true"));
            this.injector = new POJOInjector();
            this.serviceMixin = new ServiceMixin(resource);
            List mmois = Tools.toList((Object[])info.getOperations());
            List mmais = Tools.toList((Object[])info.getAttributes());
            boolean createExists = false;
            boolean startExists = false;
            boolean stopExists = false;
            boolean destroyExists = false;
            boolean getStateExists = false;
            boolean getStateStringExists = false;
            boolean getManagedResourceExists = false;
            for (int i = 0; i < mmois.size(); ++i) {
                ModelMBeanOperationInfo mmoi = (ModelMBeanOperationInfo)mmois.get(i);
                if (mmoi.getSignature().length != 0) continue;
                if (mmoi.getName().equals("create")) {
                    createExists = true;
                    continue;
                }
                if (mmoi.getName().equals("start")) {
                    startExists = true;
                    continue;
                }
                if (mmoi.getName().equals("stop")) {
                    stopExists = true;
                    continue;
                }
                if (mmoi.getName().equals("destroy")) {
                    destroyExists = true;
                    continue;
                }
                if (mmoi.getName().equals("getState")) {
                    getStateExists = true;
                    continue;
                }
                if (mmoi.getName().equals("getStateString")) {
                    getStateStringExists = true;
                    continue;
                }
                if (!mmoi.getName().equals("getManagedResource")) continue;
                getManagedResourceExists = true;
            }
            this.createExists = createExists;
            this.startExists = startExists;
            this.stopExists = stopExists;
            this.destroyExists = destroyExists;
            this.getStateExists = getStateExists;
            this.getStateStringExists = getStateStringExists;
            this.getManagedResourceExists = getManagedResourceExists;
            if (!createExists) {
                mmois.add(serviceMixinInfo.getOperation("create"));
            }
            if (!startExists) {
                mmois.add(serviceMixinInfo.getOperation("start"));
            }
            if (!stopExists) {
                mmois.add(serviceMixinInfo.getOperation("stop"));
            }
            if (!destroyExists) {
                mmois.add(serviceMixinInfo.getOperation("destroy"));
            }
            if (!getStateExists) {
                mmois.add(serviceMixinInfo.getOperation("getState"));
                mmais.add(serviceMixinInfo.getAttribute("State"));
            }
            if (!getStateStringExists) {
                mmois.add(serviceMixinInfo.getOperation("getStateString"));
                mmais.add(serviceMixinInfo.getAttribute("StateString"));
            }
            if (!getManagedResourceExists) {
                mmois.add(serviceMixinInfo.getOperation("getManagedResource"));
                mmais.add(serviceMixinInfo.getAttribute("ManagedResource"));
            }
            info = new ModelMBeanInfoSupport(info.getClassName(), info.getDescription(), mmais.toArray(new ModelMBeanAttributeInfo[mmais.size()]), (ModelMBeanConstructorInfo[])info.getConstructors(), mmois.toArray(new ModelMBeanOperationInfo[mmois.size()]), (ModelMBeanNotificationInfo[])info.getNotifications());
            this.setModelMBeanInfo(info);
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e, "Unsupported resource type: " + this.resourceType);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public boolean isSupportedResourceType(Object resource, String resourceType) {
        return "ObjectReference".equals(resourceType);
    }

    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    protected void initDispatchers() {
        super.initDispatchers();
        for (InvocationContext ctx : this.attributeContextMap.values()) {
            if ("State".equals(ctx.getName())) {
                ctx.setDispatcher((Interceptor)new AbstractInterceptor(){

                    public Object invoke(Invocation invocation) throws Throwable {
                        return new Integer(JBossServiceModelMBean.this.serviceMixin.getState());
                    }
                });
                continue;
            }
            if ("StateString".equals(ctx.getName())) {
                ctx.setDispatcher((Interceptor)new AbstractInterceptor(){

                    public Object invoke(Invocation invocation) throws Throwable {
                        return JBossServiceModelMBean.this.serviceMixin.getStateString();
                    }
                });
                continue;
            }
            if ("ManagedResource".equals(ctx.getName())) {
                ctx.setDispatcher((Interceptor)new AbstractInterceptor(){

                    public Object invoke(Invocation invocation) throws Throwable {
                        return JBossServiceModelMBean.this.serviceMixin.getManagedResource();
                    }
                });
                continue;
            }
            if (!this.replaceProxies) continue;
            final Interceptor dispatcher = ctx.getDispatcher();
            ctx.setDispatcher((Interceptor)new AbstractInterceptor(){

                public Object invoke(Invocation invocation) throws Throwable {
                    if ("setAttribute".equals(invocation.getType())) {
                        Object value = invocation.getArgs()[0];
                        if (value != null && Proxy.isProxyClass(value.getClass())) {
                            InvocationHandler handler = Proxy.getInvocationHandler(value);
                            if (handler instanceof MBeanProxyExt) {
                                MBeanProxyExt pojoHandler = (MBeanProxyExt)handler;
                                POJOInjection injection = new POJOInjection(pojoHandler, dispatcher, invocation);
                                JBossServiceModelMBean.this.injector.addInjection(injection);
                            } else {
                                dispatcher.invoke(invocation);
                            }
                        } else {
                            dispatcher.invoke(invocation);
                        }
                        return null;
                    }
                    return dispatcher.invoke(invocation);
                }
            });
        }
        for (InvocationContext ctx : this.operationContextMap.values()) {
            if ("create".equals(ctx.getName())) {
                ctx.setDispatcher((Interceptor)new AbstractInterceptor(){

                    public Object invoke(Invocation invocation) throws Throwable {
                        JBossServiceModelMBean.this.serviceMixin.create();
                        return null;
                    }
                });
                continue;
            }
            if ("start".equals(ctx.getName())) {
                ctx.setDispatcher((Interceptor)new AbstractInterceptor(){

                    public Object invoke(Invocation invocation) throws Throwable {
                        JBossServiceModelMBean.this.serviceMixin.start();
                        return null;
                    }
                });
                continue;
            }
            if ("stop".equals(ctx.getName())) {
                ctx.setDispatcher((Interceptor)new AbstractInterceptor(){

                    public Object invoke(Invocation invocation) throws Throwable {
                        JBossServiceModelMBean.this.serviceMixin.stop();
                        return null;
                    }
                });
                continue;
            }
            if ("destroy".equals(ctx.getName())) {
                ctx.setDispatcher((Interceptor)new AbstractInterceptor(){

                    public Object invoke(Invocation invocation) throws Throwable {
                        JBossServiceModelMBean.this.serviceMixin.destroy();
                        return null;
                    }
                });
                continue;
            }
            if ("getState".equals(ctx.getName())) {
                ctx.setDispatcher((Interceptor)new AbstractInterceptor(){

                    public Object invoke(Invocation invocation) throws Throwable {
                        return new Integer(JBossServiceModelMBean.this.serviceMixin.getState());
                    }
                });
                continue;
            }
            if ("getStateString".equals(ctx.getName())) {
                ctx.setDispatcher((Interceptor)new AbstractInterceptor(){

                    public Object invoke(Invocation invocation) throws Throwable {
                        return JBossServiceModelMBean.this.serviceMixin.getStateString();
                    }
                });
                continue;
            }
            if (!"getManagedResource".equals(ctx.getName())) continue;
            ctx.setDispatcher((Interceptor)new AbstractInterceptor(){

                public Object invoke(Invocation invocation) throws Throwable {
                    return JBossServiceModelMBean.this.serviceMixin.getManagedResource();
                }
            });
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        name = super.preRegister(server, name);
        server.addNotificationListener(JMXConstants.MBEAN_SERVER_DELEGATE, this.injector, null, null);
        return name;
    }

    public void postRegister(Boolean done) {
        super.postRegister(done);
    }

    public void preDeregister() throws Exception {
        this.getServer().removeNotificationListener(JMXConstants.MBEAN_SERVER_DELEGATE, this.injector);
        super.preDeregister();
    }

    public void postDeregister() {
        super.postDeregister();
    }

    static {
        try {
            serviceMixinInfo = JavaBeanModelMBeanBuilder.build(ServiceMixin.class, Object.class);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        log = Logger.getLogger(JBossServiceModelMBean.class);
    }

    private static class ServiceMixin
    extends ServiceMBeanSupport {
        private final Object resource;

        public ServiceMixin(Object resource) {
            this.resource = resource;
        }

        protected void createService() throws Exception {
            this.execute("create");
        }

        protected void startService() throws Exception {
            this.execute("start");
        }

        protected void stopService() throws Exception {
            this.execute("stop");
        }

        protected void destroyService() throws Exception {
            this.execute("destroy");
        }

        public Object getManagedResource() {
            return this.resource;
        }

        private void execute(String lifecycle) throws Exception {
            Method m = null;
            try {
                m = this.resource.getClass().getMethod(lifecycle, new Class[0]);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
            if (m != null) {
                try {
                    m.invoke(this.resource, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new Error(e);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw new Error(t);
                }
            }
        }
    }
}

