/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.spi;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;

public class MethodInfoHashing {
    public static long methodHash(MethodInfo method) throws Exception {
        TypeInfo[] parameterTypes = method.getParameterTypes();
        String methodDesc = method.getName() + "(";
        for (int j = 0; j < parameterTypes.length; ++j) {
            methodDesc = methodDesc + MethodInfoHashing.getTypeString(parameterTypes[j]);
        }
        methodDesc = methodDesc + ")" + MethodInfoHashing.getTypeString(method.getReturnType());
        return MethodInfoHashing.createHash(methodDesc);
    }

    public static long createHash(String methodDesc) throws Exception {
        long hash = 0L;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
        MessageDigest messagedigest = MessageDigest.getInstance("SHA");
        DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
        dataoutputstream.writeUTF(methodDesc);
        dataoutputstream.flush();
        byte[] abyte0 = messagedigest.digest();
        for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
            hash += (long)(abyte0[j] & 0xFF) << j * 8;
        }
        return hash;
    }

    static String getTypeString(TypeInfo cl) {
        if (cl == PrimitiveInfo.BYTE) {
            return "B";
        }
        if (cl == PrimitiveInfo.CHAR) {
            return "C";
        }
        if (cl == PrimitiveInfo.DOUBLE) {
            return "D";
        }
        if (cl == PrimitiveInfo.FLOAT) {
            return "F";
        }
        if (cl == PrimitiveInfo.INT) {
            return "I";
        }
        if (cl == PrimitiveInfo.LONG) {
            return "J";
        }
        if (cl == PrimitiveInfo.SHORT) {
            return "S";
        }
        if (cl == PrimitiveInfo.BOOLEAN) {
            return "Z";
        }
        if (cl == PrimitiveInfo.VOID) {
            return "V";
        }
        if (cl instanceof ArrayInfo) {
            ArrayInfo ai = (ArrayInfo)cl;
            return "[" + MethodInfoHashing.getTypeString(ai.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }
}

