/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.state.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.portal.common.NotYetImplemented;
import org.jboss.portal.portlet.InvalidPortletIdException;
import org.jboss.portal.portlet.NoSuchPortletException;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.PortletInvokerInterceptor;
import org.jboss.portal.portlet.StateEvent;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.spi.InstanceContext;
import org.jboss.portal.portlet.state.AccessMode;
import org.jboss.portal.portlet.state.DestroyCloneFailure;
import org.jboss.portal.portlet.state.InvalidStateIdException;
import org.jboss.portal.portlet.state.NoSuchStateException;
import org.jboss.portal.portlet.state.PropertyChange;
import org.jboss.portal.portlet.state.PropertyMap;
import org.jboss.portal.portlet.state.consumer.ConsumerPersistenceManager;
import org.jboss.portal.portlet.state.consumer.ConsumerPortlet;
import org.jboss.portal.portlet.state.consumer.ConsumerState;
import org.jboss.portal.portlet.state.consumer.ConsumerStateContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerPortletInvoker
extends PortletInvokerInterceptor {
    private static final String CLONE_ID_PREFIX = "@";
    private ConsumerPersistenceManager persistenceManager;

    public PortletContext unwrapCCP(String wrappedCCP) throws InvalidPortletIdException {
        if (wrappedCCP == null) {
            throw new IllegalArgumentException();
        }
        if (!wrappedCCP.startsWith(CLONE_ID_PREFIX)) {
            throw new InvalidPortletIdException(wrappedCCP);
        }
        return PortletContext.createPortletContext(wrappedCCP.substring(CLONE_ID_PREFIX.length()));
    }

    public PortletContext unwrapPOP(String wrappedPOPId) throws InvalidPortletIdException {
        if (wrappedPOPId == null) {
            throw new IllegalArgumentException();
        }
        return PortletContext.createPortletContext(wrappedPOPId);
    }

    public String wrapCCP(PortletContext ccpCtx) throws InvalidPortletIdException {
        if (ccpCtx == null) {
            throw new IllegalArgumentException();
        }
        return CLONE_ID_PREFIX + ccpCtx.getId();
    }

    public String wrapPOP(PortletContext popCtx) throws InvalidPortletIdException {
        if (popCtx == null) {
            throw new IllegalArgumentException();
        }
        if (popCtx.getId().startsWith(CLONE_ID_PREFIX)) {
            throw new IllegalArgumentException("Must not start with @");
        }
        return popCtx.getId();
    }

    public void setPersistenceManager(ConsumerPersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    @Override
    public Set<Portlet> getPortlets() throws PortletInvokerException {
        return super.getPortlets();
    }

    @Override
    public Portlet getPortlet(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        return this.getConsumerContext(portletContext).getPortlet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        PortletContext portletContext = invocation.getTarget();
        if (portletContext == null) {
            throw new IllegalArgumentException();
        }
        ConsumerContext consumerContext = this.getConsumerContext(portletContext);
        InstanceContext cictx = invocation.getInstanceContext();
        StatefulInstanceContextImpl pictx = new StatefulInstanceContextImpl(cictx);
        try {
            invocation.setTarget(consumerContext.producerPortletContext);
            invocation.setInstanceContext(pictx);
            PortletInvocationResponse response = super.invoke(invocation);
            PortletContext clonedContext = pictx.clonedContext;
            if (clonedContext != null) {
                byte[] state = clonedContext.getState();
                if (state != null) {
                    ConsumerState consumerState = new ConsumerState(clonedContext.getId(), state);
                    String stateId = this.persistenceManager.createState(consumerState);
                    String clonedId = CLONE_ID_PREFIX + stateId;
                    StateEvent event = new StateEvent(PortletContext.createPortletContext(clonedId), StateEvent.Type.PORTLET_CLONED_EVENT);
                    cictx.onStateEvent(event);
                } else {
                    StateEvent event = new StateEvent(PortletContext.createPortletContext(clonedContext.getId()), StateEvent.Type.PORTLET_CLONED_EVENT);
                    cictx.onStateEvent(event);
                }
            } else {
                byte[] state;
                PortletContext modifiedContext = pictx.modifiedContext;
                if (modifiedContext != null && (state = modifiedContext.getState()) != null) {
                    try {
                        ConsumerState consumerState = new ConsumerState(modifiedContext.getId(), state);
                        this.persistenceManager.updateState(consumerContext.stateId, consumerState);
                    }
                    catch (NoSuchStateException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidStateIdException e) {
                        e.printStackTrace();
                    }
                }
            }
            PortletInvocationResponse portletInvocationResponse = response;
            return portletInvocationResponse;
        }
        finally {
            invocation.setTarget(portletContext);
            invocation.setInstanceContext(cictx);
        }
    }

    @Override
    public PortletContext createClone(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ConsumerContext consumerContext = this.getConsumerContext(portletContext);
        PortletContext clonedContext = super.createClone(consumerContext.producerPortletContext);
        byte[] state = clonedContext.getState();
        if (state != null) {
            ConsumerState consumerState = new ConsumerState(clonedContext.getId(), state);
            String id = this.persistenceManager.createState(consumerState);
            return PortletContext.createPortletContext(CLONE_ID_PREFIX + id);
        }
        return clonedContext;
    }

    @Override
    public List<DestroyCloneFailure> destroyClones(List<PortletContext> portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        if (portletContexts == null) {
            throw new IllegalArgumentException();
        }
        portletContexts = new ArrayList<PortletContext>(portletContexts);
        for (int i = 0; i < portletContexts.size(); ++i) {
            PortletContext portletContext = portletContexts.get(i);
            ConsumerContext consumerContext = this.getConsumerContext(portletContext);
            portletContexts.set(i, consumerContext.producerPortletContext);
            if (consumerContext.stateId == null) continue;
            try {
                this.persistenceManager.destroyState(consumerContext.stateId);
                continue;
            }
            catch (NoSuchStateException e) {
                continue;
            }
            catch (InvalidStateIdException e) {
                // empty catch block
            }
        }
        List<DestroyCloneFailure> failures = super.destroyClones(portletContexts);
        return failures;
    }

    @Override
    public PropertyMap getProperties(PortletContext portletContext, Set<String> keys) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ConsumerContext consumerContext = this.getConsumerContext(portletContext);
        return super.getProperties(consumerContext.producerPortletContext, keys);
    }

    @Override
    public PropertyMap getProperties(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ConsumerContext consumerContext = this.getConsumerContext(portletContext);
        return super.getProperties(consumerContext.producerPortletContext);
    }

    @Override
    public PortletContext setProperties(PortletContext portletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ConsumerContext consumerContext = this.getConsumerContext(portletContext);
        PortletContext updatedPortletContext = super.setProperties(consumerContext.producerPortletContext, changes);
        byte[] state = updatedPortletContext.getState();
        if (state != null) {
            if (consumerContext.stateId == null) {
                throw new NotYetImplemented();
            }
            ConsumerState consumerState = new ConsumerState(updatedPortletContext.getId(), state);
            try {
                this.persistenceManager.updateState(consumerContext.stateId, consumerState);
            }
            catch (NoSuchStateException e) {
            }
            catch (InvalidStateIdException e) {}
        } else if (consumerContext.stateId != null) {
            throw new NotYetImplemented();
        }
        return portletContext;
    }

    private ConsumerContext getConsumerContext(PortletContext portletContext) throws IllegalArgumentException, InvalidPortletIdException {
        if (portletContext == null) {
            throw new IllegalArgumentException();
        }
        String portletId = portletContext.getId();
        if (portletId.startsWith(CLONE_ID_PREFIX)) {
            String stateId = portletId.substring(CLONE_ID_PREFIX.length());
            try {
                ConsumerStateContext stateCtx = this.persistenceManager.loadState(stateId);
                return new ConsumerContext(portletContext, PortletContext.createStatefulPortletContext(stateCtx.getPortletId(), stateCtx.getBytes()), stateId);
            }
            catch (NoSuchStateException e) {
                throw new NoSuchPortletException(portletId);
            }
            catch (InvalidStateIdException e) {
                throw new InvalidPortletIdException(portletId);
            }
        }
        return new ConsumerContext(portletContext, portletContext, null);
    }

    private class ConsumerContext {
        private final PortletContext consumerPortletContext;
        private final PortletContext producerPortletContext;
        private final String stateId;
        private Portlet portlet;

        public ConsumerContext(PortletContext consumerPortletContext, PortletContext producerPortletContext, String stateId) {
            this.consumerPortletContext = consumerPortletContext;
            this.producerPortletContext = producerPortletContext;
            this.stateId = stateId;
        }

        public Portlet getPortlet() throws PortletInvokerException {
            if (this.portlet == null) {
                Portlet producerPortlet = ConsumerPortletInvoker.super.getPortlet(this.producerPortletContext);
                this.portlet = this.stateId == null ? producerPortlet : new ConsumerPortlet(this.consumerPortletContext, producerPortlet);
            }
            return this.portlet;
        }
    }

    private static class StatefulInstanceContextImpl
    implements InstanceContext {
        private InstanceContext cictx;
        private PortletContext clonedContext;
        private PortletContext modifiedContext;

        public StatefulInstanceContextImpl(InstanceContext cictx) {
            this.cictx = cictx;
        }

        public String getId() {
            return this.cictx.getId();
        }

        public AccessMode getAccessMode() {
            return this.cictx.getAccessMode();
        }

        public void onStateEvent(StateEvent event) {
            switch (event.getType()) {
                case PORTLET_CLONED_EVENT: {
                    this.clonedContext = event.getPortletContext();
                    break;
                }
                case PORTLET_MODIFIED_EVENT: {
                    this.modifiedContext = event.getPortletContext();
                }
            }
        }
    }
}

