/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.util;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte STAR = 42;
    private byte PADDING_CHAR;
    private static final byte NEW_LINE = 10;
    private static final String PREFERRED_ENCODING = "UTF-8";
    private byte[] ALPHABET;
    private static final byte[] NATIVE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] NATIVE_URL_SAFE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final int IGNORE = -9;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte PADDING_CHAR_ENC = -1;
    private byte[] DECODABET;
    private static final byte[] BASE64_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    private static final byte[] URL_SAFE_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -1, -9, -9, 62, -9, -9, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -9, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, 63, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    private static final Base64 STANDARD_BASE64 = new Base64();
    private static final Base64 URL_SAFE_BASE64 = new Base64(true);

    public void initAlphabets(boolean useURLSafeEncoding) {
        byte[] __bytes;
        byte[] nativeAlphabet;
        String alphabetString;
        if (useURLSafeEncoding) {
            alphabetString = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
            nativeAlphabet = NATIVE_URL_SAFE_ALPHABET;
            this.PADDING_CHAR = (byte)42;
            this.DECODABET = URL_SAFE_DECODABET;
        } else {
            alphabetString = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
            nativeAlphabet = NATIVE_ALPHABET;
            this.PADDING_CHAR = (byte)61;
            this.DECODABET = BASE64_DECODABET;
        }
        try {
            __bytes = alphabetString.getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException use) {
            __bytes = nativeAlphabet;
        }
        this.ALPHABET = __bytes;
    }

    private Base64() {
        this(false);
    }

    private Base64(boolean useURLSafeEncoding) {
        this.initAlphabets(useURLSafeEncoding);
    }

    private static Base64 getBase64(EncodingOption option) {
        return EncodingOption.USEURLSAFEENCODING.equals((Object)option) ? URL_SAFE_BASE64 : STANDARD_BASE64;
    }

    private byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = this.ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = this.ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = this.ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = this.ALPHABET[inBuff & 0x3F];
                return destination;
            }
            case 2: {
                destination[destOffset] = this.ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = this.ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = this.ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = this.PADDING_CHAR;
                return destination;
            }
            case 1: {
                destination[destOffset] = this.ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = this.ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = this.PADDING_CHAR;
                destination[destOffset + 3] = this.PADDING_CHAR;
                return destination;
            }
        }
        return destination;
    }

    public static String encodeBytes(byte[] source) {
        return Base64.encodeBytes(source, EncodingOption.STANDARD);
    }

    public static String encodeBytes(byte[] source, EncodingOption option) {
        return Base64.encodeBytes(source, 0, source.length, option);
    }

    public static String encodeBytes(byte[] source, int off, int len, EncodingOption option) {
        Base64 b64 = Base64.getBase64(option);
        int len43 = len * 4 / 3;
        byte[] outBuff = new byte[len43 + (len % 3 > 0 ? 4 : 0) + (EncodingOption.STANDARD.equals((Object)option) ? len43 / 76 : 0)];
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            b64.encode3to4(source, d + off, 3, outBuff, e);
            if (EncodingOption.STANDARD.equals((Object)option) && (lineLength += 4) == 76) {
                outBuff[e + 4] = 10;
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            b64.encode3to4(source, d + off, len - d, outBuff, e);
            e += 4;
        }
        try {
            return new String(outBuff, 0, e, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException uue) {
            return new String(outBuff, 0, e);
        }
    }

    private int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset) {
        if (source[srcOffset + 2] == this.PADDING_CHAR) {
            int outBuff = (this.DECODABET[source[srcOffset]] & 0xFF) << 18 | (this.DECODABET[source[srcOffset + 1]] & 0xFF) << 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source[srcOffset + 3] == this.PADDING_CHAR) {
            int outBuff = (this.DECODABET[source[srcOffset]] & 0xFF) << 18 | (this.DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (this.DECODABET[source[srcOffset + 2]] & 0xFF) << 6;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        try {
            int outBuff = (this.DECODABET[source[srcOffset]] & 0xFF) << 18 | (this.DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (this.DECODABET[source[srcOffset + 2]] & 0xFF) << 6 | this.DECODABET[source[srcOffset + 3]] & 0xFF;
            destination[destOffset] = (byte)(outBuff >> 16);
            destination[destOffset + 1] = (byte)(outBuff >> 8);
            destination[destOffset + 2] = (byte)outBuff;
            return 3;
        }
        catch (Exception e) {
            System.out.println("" + source[srcOffset] + ": " + this.DECODABET[source[srcOffset]]);
            System.out.println("" + source[srcOffset + 1] + ": " + this.DECODABET[source[srcOffset + 1]]);
            System.out.println("" + source[srcOffset + 2] + ": " + this.DECODABET[source[srcOffset + 2]]);
            System.out.println("" + source[srcOffset + 3] + ": " + this.DECODABET[source[srcOffset + 3]]);
            return -1;
        }
    }

    private byte[] decode(int len, int off, byte[] source) {
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i = 0;
        byte sbiCrop = 0;
        byte sbiDecode = 0;
        for (i = off; i < off + len; ++i) {
            sbiCrop = (byte)(source[i] & 0x7F);
            sbiDecode = this.DECODABET[sbiCrop];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = sbiCrop;
                if (b4Posn <= 3) continue;
                outBuffPosn += this.decode4to3(b4, 0, outBuff, outBuffPosn);
                b4Posn = 0;
                if (sbiCrop != this.PADDING_CHAR) continue;
                break;
            }
            System.err.println("Bad Base64 input character at " + i + ": " + source[i] + "(decimal)");
            return null;
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }

    public static byte[] decode(byte[] source, int off, int len, EncodingOption optionThatWasUsed) {
        return Base64.getBase64(optionThatWasUsed).decode(len, off, source);
    }

    public static byte[] decode(String s, EncodingOption optionThatWasUsed) {
        byte[] bytes;
        try {
            bytes = s.getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            bytes = s.getBytes();
        }
        bytes = Base64.decode(bytes, 0, bytes.length, optionThatWasUsed);
        return bytes;
    }

    public static byte[] decode(String s) {
        return Base64.decode(s, EncodingOption.STANDARD);
    }

    public static String encodeBytes(byte[] source, boolean useURLSafeEncoding) {
        if (useURLSafeEncoding) {
            return Base64.encodeBytes(source, EncodingOption.USEURLSAFEENCODING);
        }
        return Base64.encodeBytes(source, EncodingOption.STANDARD);
    }

    public static String encodeBytes(byte[] source, int off, int len, boolean useURLSafeEncoding) {
        return useURLSafeEncoding ? Base64.encodeBytes(source, off, len, EncodingOption.USEURLSAFEENCODING) : Base64.encodeBytes(source, off, len, EncodingOption.STANDARD);
    }

    public static byte[] decode(byte[] source, int off, int len, boolean urlSafeEncodingWasUsed) {
        EncodingOption option = EncodingOption.STANDARD;
        if (urlSafeEncodingWasUsed) {
            option = EncodingOption.USEURLSAFEENCODING;
        }
        return Base64.decode(source, off, len, option);
    }

    public static byte[] decode(String s, boolean urlSafeEncodingWasUsed) {
        EncodingOption option = EncodingOption.STANDARD;
        if (urlSafeEncodingWasUsed) {
            option = EncodingOption.USEURLSAFEENCODING;
        }
        return Base64.decode(s, option);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EncodingOption {
        USEURLSAFEENCODING,
        NOCARRIAGERETURN,
        STANDARD;

    }
}

