/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.xml.XMLTools;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class LoaderResource {
    protected final String location;
    private final Logger log = Logger.getLogger(this.getClass());

    public LoaderResource(String location) {
        if (location == null) {
            throw new IllegalArgumentException();
        }
        this.location = location;
    }

    public abstract boolean exists();

    public abstract InputStream asInputStream() throws IllegalStateException;

    public String getLocation() {
        return this.location;
    }

    public Document asDocument(DocumentBuilder builder) throws IllegalStateException {
        if (!this.exists()) {
            throw new IllegalStateException("Resource " + this.location + " does not exist");
        }
        BufferedInputStream in = null;
        try {
            in = IOTools.safeBufferedWrapper(this.asInputStream());
            Document document = builder.parse(in);
            return document;
        }
        catch (SAXException e) {
            IllegalStateException ex = new IllegalStateException("Cannot parse stream " + this.location);
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException("Cannot access stream " + this.location);
            ex.initCause(e);
            throw ex;
        }
        finally {
            IOTools.safeClose(in);
        }
    }

    public Properties asProperties() throws IllegalStateException {
        return this.asProperties(false);
    }

    public Properties asProperties(boolean xml) throws IllegalStateException {
        if (!this.exists()) {
            throw new IllegalStateException("Resource " + this.location + " does not exist");
        }
        BufferedInputStream in = null;
        this.log.debug((Object)("Loading resource: " + this.location));
        try {
            Properties props;
            Object builder;
            in = IOTools.safeBufferedWrapper(this.asInputStream());
            if (xml) {
                builder = XMLTools.getDocumentBuilderFactory().newDocumentBuilder();
                Document doc = this.asDocument((DocumentBuilder)builder);
                props = XMLTools.loadXMLProperties(doc);
            } else {
                props = new Properties();
                props.load(in);
            }
            this.log.debug((Object)("Finished loading resource: " + this.location));
            builder = props;
            return builder;
        }
        catch (ParserConfigurationException e) {
            IllegalStateException ex = new IllegalStateException("Cannot parse xml stream " + this.location);
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException("Cannot access stream " + this.location);
            ex.initCause(e);
            throw ex;
        }
        finally {
            IOTools.safeClose(in);
        }
    }

    public String asString() throws IllegalStateException {
        return this.asString(null);
    }

    public String asString(String enc) throws IllegalStateException {
        if (!this.exists()) {
            throw new IllegalStateException("Resource " + this.location + " does not exist");
        }
        BufferedInputStream in = null;
        this.log.debug((Object)("Loading resource: " + this.location));
        try {
            in = IOTools.safeBufferedWrapper(this.asInputStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream(((InputStream)in).available());
            IOTools.copy(in, out);
            String result = enc == null ? out.toString() : out.toString(enc);
            this.log.debug((Object)("Finished loading resource: " + this.location));
            String string = result;
            return string;
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException("Cannot access stream " + this.location);
            ex.initCause(e);
            throw ex;
        }
        finally {
            IOTools.safeClose(in);
        }
    }
}

