/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.taglib.common;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoServiceFactory;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.api.services.tag.INuxeoTagService;
import java.io.IOException;
import javax.portlet.PortletRequest;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.taglib.common.PortalSimpleTag;

public abstract class ToutaticeSimpleTag
extends PortalSimpleTag {
    private static final String NUXEO_CONTROLLER_REQUEST_ATTRIBUTE = NuxeoController.class.getName();
    private DocumentDTO document;
    private String path;
    private final INuxeoTagService tagService = NuxeoServiceFactory.getTagService();
    private final DocumentDAO dao = DocumentDAO.getInstance();

    public void doTag() throws JspException, IOException {
        PortalControllerContext portalControllerContext = this.getPortalControllerContext();
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        if (this.document == null && StringUtils.isNotBlank((String)this.path)) {
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(this.path);
            Document document = documentContext.getDocument();
            nuxeoController.setCurrentDoc(document);
            this.document = this.dao.toDTO(portalControllerContext, document);
        }
        this.doTag(nuxeoController, this.document);
    }

    protected NuxeoController getNuxeoController(PortalControllerContext portalControllerContext) throws JspException {
        PortletRequest request = this.getPortletRequest();
        NuxeoController nuxeoController = request == null ? null : (NuxeoController)request.getAttribute(NUXEO_CONTROLLER_REQUEST_ATTRIBUTE);
        if (nuxeoController == null) {
            nuxeoController = new NuxeoController(portalControllerContext);
            if (request != null) {
                request.setAttribute(NUXEO_CONTROLLER_REQUEST_ATTRIBUTE, (Object)nuxeoController);
            }
        }
        if (this.document != null) {
            Document nuxeoDocument = this.document.getDocument();
            nuxeoController.setCurrentDoc(nuxeoDocument);
        } else {
            nuxeoController.setCurrentDoc(null);
        }
        return nuxeoController;
    }

    protected abstract void doTag(NuxeoController var1, DocumentDTO var2) throws JspException, IOException;

    public void setDocument(DocumentDTO document) {
        this.document = document;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public INuxeoTagService getTagService() {
        return this.tagService;
    }
}

