/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.taglib.toutatice;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.taglib.common.ToutaticeSimpleTag;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.html.HtmlFormatter;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;

public class FileSizeTag
extends ToutaticeSimpleTag {
    private final IBundleFactory bundleFactory;
    private Long size;
    private Boolean escapeHtml;

    public FileSizeTag() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(((Object)((Object)this)).getClass().getClassLoader());
    }

    @Override
    protected void doTag(NuxeoController nuxeoController, DocumentDTO document) throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest request = pageContext.getRequest();
        Locale locale = request.getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        String text = HtmlFormatter.formatSize((Locale)locale, (Bundle)bundle, (long)this.size);
        if (BooleanUtils.isFalse((Boolean)this.escapeHtml)) {
            text = StringUtils.replace((String)text, (String)"&nbsp;", (String)"\u202f");
        }
        JspWriter out = pageContext.getOut();
        out.write(text);
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setEscapeHtml(Boolean escapeHtml) {
        this.escapeHtml = escapeHtml;
    }
}

