/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.Version;
import org.jboss.remoting.transport.ClientInvoker;

public class InvokerLocator
implements Serializable {
    static final long serialVersionUID;
    protected static Logger log;
    protected static Boolean legacyParsingFlag;
    protected String protocol;
    protected String host;
    protected int port;
    protected String path;
    protected String query;
    protected Map parameters;
    private String uri;
    private String originalURL;
    public static final String ANY = "0.0.0.0";
    private static final String SERVER_BIND_ADDRESS = "jboss.bind.address";
    public static final String BIND_BY_HOST = "remoting.bind_by_host";
    public static final String DATATYPE = "datatype";
    public static final String DATATYPE_CASED = "dataType";
    public static final String SERIALIZATIONTYPE = "serializationtype";
    public static final String SERIALIZATIONTYPE_CASED = "serializationType";
    public static final String MARSHALLER = "marshaller";
    public static final String UNMARSHALLER = "unmarshaller";
    public static final String LOADER_PORT = "loaderport";
    public static final String BYVALUE = "byvalue";
    public static final String FORCE_REMOTE = "force_remote";
    public static final String CLIENT_LEASE = "leasing";
    public static final String CLIENT_LEASE_PERIOD = "lease_period";
    public static final String LEGACY_PARSING = "legacyParsing";

    public static boolean getUseLegacyParsing() {
        if (legacyParsingFlag == null) {
            return false;
        }
        return legacyParsingFlag;
    }

    public static void setUseLegacyParsing(boolean flag) {
        legacyParsingFlag = new Boolean(flag);
    }

    public static InvokerLocator validateLocator(InvokerLocator locator) throws MalformedURLException {
        InvokerLocator externalLocator = locator;
        String host = locator.getHost();
        String newHost = null;
        if (host == null || ANY.equals(host)) {
            try {
                newHost = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String bindByHost = System.getProperty(InvokerLocator.BIND_BY_HOST, "True");
                        boolean byHost = Boolean.valueOf(bindByHost);
                        if (byHost) {
                            return InetAddress.getLocalHost().getHostName();
                        }
                        return InetAddress.getLocalHost().getHostAddress();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                log.debug((Object)"Could not get host by name or address.", e.getCause());
            }
            if (newHost == null) {
                throw new RuntimeException("Can not determine bindable address for locator (" + locator + ")");
            }
            externalLocator = new InvokerLocator(locator.protocol, newHost, locator.port, locator.getPath(), locator.getParameters());
        }
        return externalLocator;
    }

    public InvokerLocator(String uri) throws MalformedURLException {
        this.originalURL = uri;
        this.parse(uri);
    }

    private void parse(String uriString) throws MalformedURLException {
        boolean doLegacyParsing = false;
        if (legacyParsingFlag != null) {
            doLegacyParsing = legacyParsingFlag;
        } else if (System.getProperty(LEGACY_PARSING) != null) {
            doLegacyParsing = Boolean.getBoolean(LEGACY_PARSING);
        }
        if (doLegacyParsing) {
            log.warn((Object)"using deprecated legacy URL parsing routine");
            this.legacyParse(uriString);
        } else {
            this.URIParse(uriString);
        }
        if (this.query != null) {
            StringTokenizer tok = new StringTokenizer(this.query, "&");
            this.parameters = new TreeMap();
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int eq = token.indexOf("=");
                String name = eq > -1 ? token.substring(0, eq) : token;
                String value = eq > -1 ? token.substring(eq + 1) : "";
                this.parameters.put(name, value);
            }
        }
        String portPart = this.port > -1 ? ":" + this.port : "";
        String divider = this.path.startsWith("/") ? "" : "/";
        String parametersPart = this.parameters != null ? "?" : "";
        this.uri = this.protocol + "://" + this.host + portPart + divider + this.path + parametersPart;
        if (this.parameters != null) {
            Iterator iter = this.parameters.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = (String)this.parameters.get(key);
                this.uri = this.uri + key + "=" + val;
                if (!iter.hasNext()) continue;
                this.uri = this.uri + "&";
            }
        }
    }

    private void URIParse(String uriString) throws MalformedURLException {
        try {
            URI uri = new URI(InvokerLocator.encodePercent(uriString));
            this.protocol = uri.getScheme();
            this.host = InvokerLocator.decodePercent(InvokerLocator.resolveHost(uri.getHost()));
            this.port = uri.getPort();
            this.path = uri.getPath();
            this.query = InvokerLocator.decodePercent(uri.getQuery());
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    private void legacyParse(String uri) throws MalformedURLException {
        log.warn((Object)"Legacy InvokerLocator parsing is deprecated");
        int i = uri.indexOf("://");
        if (i < 0) {
            throw new MalformedURLException("Invalid url " + uri);
        }
        String tmp = uri.substring(i + 3);
        this.protocol = uri.substring(0, i);
        i = tmp.indexOf("/");
        int p = tmp.indexOf(":");
        if (i != -1) {
            int n = p = p < i ? p : -1;
        }
        if (p != -1) {
            this.host = InvokerLocator.resolveHost(tmp.substring(0, p).trim());
            this.port = i > -1 ? Integer.parseInt(tmp.substring(p + 1, i)) : Integer.parseInt(tmp.substring(p + 1));
        } else {
            this.host = i > -1 ? InvokerLocator.resolveHost(tmp.substring(0, i).trim()) : InvokerLocator.resolveHost(tmp.substring(0).trim());
            this.port = -1;
        }
        p = tmp.indexOf("?");
        if (p != -1) {
            this.path = tmp.substring(i + 1, p);
            this.query = tmp.substring(p + 1);
        } else {
            p = tmp.indexOf("/");
            this.path = p != -1 ? tmp.substring(p + 1) : "";
            this.query = null;
        }
    }

    private static final String resolveHost(String host) {
        if (host == null) {
            host = InvokerLocator.fixRemoteAddress(host);
        } else if (host.indexOf(ANY) != -1) {
            host = System.getProperty(SERVER_BIND_ADDRESS, ANY).equals(ANY) ? InvokerLocator.fixRemoteAddress(host) : host.replaceAll("0\\.0\\.0\\.0", System.getProperty(SERVER_BIND_ADDRESS));
        }
        return host;
    }

    private static String fixRemoteAddress(String address) {
        block5: {
            try {
                if (address != null) break block5;
                boolean byHost = true;
                String bindByHost = System.getProperty(BIND_BY_HOST, "True");
                try {
                    byHost = Boolean.getBoolean(bindByHost);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (byHost) {
                    return InetAddress.getLocalHost().getHostName();
                }
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return address;
    }

    public InvokerLocator(String protocol, String host, int port, String path, Map parameters) {
        this.protocol = protocol;
        this.host = InvokerLocator.resolveHost(host);
        this.port = port;
        this.path = path;
        this.parameters = parameters;
        this.uri = protocol + "://" + this.host + (port > -1 ? ":" + port : "") + "/" + path + (parameters != null ? "?" : "");
        if (parameters != null) {
            Iterator iter = parameters.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = (String)parameters.get(key);
                this.uri = this.uri + key + "=" + val;
                if (!iter.hasNext()) continue;
                this.uri = this.uri + "&";
            }
        }
        this.originalURL = this.uri;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof InvokerLocator && this.uri.equals(((InvokerLocator)obj).getLocatorURI());
    }

    public boolean isSameEndpoint(InvokerLocator compareMe) {
        return compareMe != null && this.getProtocol().equalsIgnoreCase(compareMe.getProtocol()) && this.getHost().equalsIgnoreCase(compareMe.getHost()) && this.getPort() == compareMe.getPort();
    }

    public String getLocatorURI() {
        return this.uri;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "InvokerLocator [" + this.uri + "]";
    }

    public String getOriginalURI() {
        return this.originalURL;
    }

    public ClientInvoker narrow() throws Exception {
        return InvokerRegistry.createClientInvoker(this);
    }

    public String findSerializationType() {
        String serializationTypeLocal = "java";
        if (this.parameters != null && (serializationTypeLocal = (String)this.parameters.get(SERIALIZATIONTYPE)) == null && (serializationTypeLocal = (String)this.parameters.get(SERIALIZATIONTYPE_CASED)) == null) {
            serializationTypeLocal = "java";
        }
        return serializationTypeLocal;
    }

    protected static String encodePercent(String s) {
        if (s == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s, "%");
        StringBuffer sb = new StringBuffer();
        int limit = st.countTokens() - 1;
        for (int i = 0; i < limit; ++i) {
            String token = st.nextToken();
            sb.append(token).append("%25");
        }
        sb.append(st.nextToken());
        return sb.toString();
    }

    protected static String decodePercent(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int fromIndex = 0;
        int index = s.indexOf("%25", fromIndex);
        while (index >= 0) {
            sb.append(s.substring(fromIndex, index)).append('%');
            fromIndex = index + 3;
            index = s.indexOf("%25", fromIndex);
        }
        sb.append(s.substring(fromIndex));
        return sb.toString();
    }

    static {
        log = Logger.getLogger((Class)InvokerLocator.class);
        serialVersionUID = Version.getDefaultVersion() == 1 ? -2909329895029296248L : -4977622166779282521L;
    }
}

