/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.jboss.portal.widget.DirectoryQueryResult;
import org.jboss.portal.widget.ExpiringFutureTask;
import org.jboss.portal.widget.Widget;
import org.jboss.portal.widget.WidgetProvider;
import org.jboss.portal.widget.WidgetQuery;
import org.jboss.portal.widget.exceptions.DirectoryResultFailure;
import org.jboss.portal.widget.exceptions.WidgetFailure;

public abstract class AbstractWidgetProvider
implements WidgetProvider {
    protected ConcurrentMap<URL, ExpiringFutureTask<Widget>> entries = new ConcurrentHashMap<URL, ExpiringFutureTask<Widget>>();
    protected ConcurrentMap<WidgetQuery, ExpiringFutureTask<DirectoryQueryResult>> queries = new ConcurrentHashMap<WidgetQuery, ExpiringFutureTask<DirectoryQueryResult>>();
    protected ExecutorService executor;
    protected ScheduledExecutorService scheduledExecutor;
    protected long entryExpiration = TimeUnit.MILLISECONDS.convert(21600L, TimeUnit.SECONDS);
    protected long queryExpiration = TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS);
    private boolean fetchWidgetsOnDirectoryLookup = false;
    protected int connectionTimeout = 10000;
    protected long timing = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private static final Logger log = Logger.getLogger(WidgetProvider.class);

    public void start() {
        this.executor = new ThreadPoolExecutor(4, 6, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(2);
        this.scheduledExecutor.scheduleAtFixedRate(new EntryEvictionThread(), this.timing, this.timing, TimeUnit.MILLISECONDS);
        this.scheduledExecutor.scheduleAtFixedRate(new QueryEvictionThread(), this.timing, this.timing, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.executor = null;
        this.scheduledExecutor = null;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setQueryExpiration(long millis) {
        this.queryExpiration = millis;
    }

    public void setEntryExpiration(long millis) {
        this.entryExpiration = millis;
    }

    public void setFetchWidgetsOnDirectoryLookup(boolean fetch) {
        this.fetchWidgetsOnDirectoryLookup = fetch;
    }

    protected abstract void addDirectoryResult(WidgetQuery var1);

    protected abstract void addWidget(URL var1);

    public Widget getWidget(URL url) {
        this.addWidget(url);
        ExpiringFutureTask entry = (ExpiringFutureTask)this.entries.get(url);
        try {
            return (Widget)entry.get();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get widget.", e.getCause());
            this.entries.remove(entry);
            return new WidgetFailure(url, e);
        }
    }

    public Widget getWidget(String string) {
        try {
            URL url = new URL(string);
            return this.getWidget(url);
        }
        catch (MalformedURLException e) {
            log.debug((Object)("Failed to create widget url out of String: " + string));
            return new WidgetFailure(null, e);
        }
    }

    private DirectoryQueryResult getDirectoryResult(WidgetQuery query) {
        this.addDirectoryResult(query);
        ExpiringFutureTask entry = (ExpiringFutureTask)this.queries.get(query);
        try {
            return (DirectoryQueryResult)entry.get();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to retreive widget directory information", (Throwable)e);
            this.queries.remove(query);
            return new DirectoryResultFailure(e);
        }
    }

    public DirectoryQueryResult search(WidgetQuery q) {
        if (q == null) {
            return new DirectoryResultFailure(new IllegalArgumentException("Query can not be null"));
        }
        DirectoryQueryResult result = this.getDirectoryResult(q);
        if (this.fetchWidgetsOnDirectoryLookup) {
            for (URL url : result.collection()) {
                this.addWidget(url);
            }
        }
        return result;
    }

    private class QueryEvictionThread
    implements Runnable {
        private QueryEvictionThread() {
        }

        public void run() {
            if (AbstractWidgetProvider.this.queries != null && AbstractWidgetProvider.this.queries.size() > 0) {
                for (WidgetQuery query : AbstractWidgetProvider.this.queries.keySet()) {
                    ExpiringFutureTask e = (ExpiringFutureTask)AbstractWidgetProvider.this.queries.get(query);
                    if (!e.isExpired()) continue;
                    AbstractWidgetProvider.this.queries.remove(query);
                }
            }
        }
    }

    private class EntryEvictionThread
    implements Runnable {
        private EntryEvictionThread() {
        }

        public void run() {
            if (AbstractWidgetProvider.this.entries != null && AbstractWidgetProvider.this.entries.size() > 0) {
                for (URL url : AbstractWidgetProvider.this.entries.keySet()) {
                    ExpiringFutureTask w = (ExpiringFutureTask)AbstractWidgetProvider.this.entries.get(url);
                    if (!w.isExpired()) continue;
                    AbstractWidgetProvider.this.entries.remove(url);
                }
            }
        }
    }
}

