/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.editor.EditorService;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.path.IBrowserService;
import org.osivia.portal.api.portlet.PortalGenericPortlet;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public abstract class CMSPortlet
extends PortalGenericPortlet {
    private final Log logger = LogFactory.getLog(CMSPortlet.class);
    private final INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    private final ICMSServiceLocator cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
    private final IBrowserService browserService = (IBrowserService)Locator.findMBean(IBrowserService.class, (String)"osivia:service=BrowserService");
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final IBundleFactory bundleFactory;
    private final EditorService editorService;

    public CMSPortlet() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(((Object)((Object)this)).getClass().getClassLoader());
        this.editorService = (EditorService)Locator.findMBean(EditorService.class, (String)"osivia:service=EditorService");
    }

    public ICMSService getCMSService() {
        return this.cmsServiceLocator.getCMSService();
    }

    public INuxeoService getNuxeoService() {
        return this.nuxeoService;
    }

    @Deprecated
    public INuxeoService getNuxeoNavigationService() throws Exception {
        return this.nuxeoService;
    }

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        try {
            new NuxeoController(this.getPortletContext()).startNuxeoService();
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void destroy() {
        try {
            new NuxeoController(this.getPortletContext()).stopNuxeoService();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        super.destroy();
    }

    public String formatResourceLastModified() {
        SimpleDateFormat inputFormater = new SimpleDateFormat("EEE, yyyy-MM-dd'T'HH:mm:ss.SS'Z'", Locale.ENGLISH);
        inputFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return inputFormater.format(new Date(System.currentTimeMillis()));
    }

    public boolean isResourceExpired(String sOriginalDate, ResourceResponse resourceResponse, String refreshMs) {
        boolean isExpired = true;
        if (sOriginalDate != null) {
            SimpleDateFormat inputFormater = new SimpleDateFormat("EEE, yyyy-MM-dd'T'HH:mm:ss.SS'Z'", Locale.ENGLISH);
            inputFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                Date originalDate = inputFormater.parse(sOriginalDate);
                if (System.currentTimeMillis() < originalDate.getTime() + (long)(resourceResponse.getCacheControl().getExpirationTime() * 1000) && (refreshMs == null || Long.parseLong(refreshMs) < originalDate.getTime())) {
                    isExpired = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isExpired;
    }

    protected void processCommentAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String action = request.getParameter("javax.portlet.action");
        String id = request.getParameter("id");
        String content = request.getParameter("content");
        if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            if ("addComment".equals(action)) {
                this.addCommentAction(request, response, content, null);
            } else if ("replyComment".equals(action)) {
                this.addCommentAction(request, response, content, id);
            } else if ("deleteComment".equals(action)) {
                this.deleteCommentAction(request, response, id);
            }
        }
    }

    protected void addCommentAction(ActionRequest request, ActionResponse response, String content, String parentId) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        NuxeoDocumentContext documentContext = nuxeoController.getCurrentDocumentContext();
        INuxeoCommentsService commentsService = nuxeoController.getNuxeoCommentsService();
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        Document document = documentContext.getDocument();
        CommentDTO comment = new CommentDTO();
        comment.setContent(content);
        try {
            commentsService.addDocumentComment(cmsContext, document, comment, parentId);
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void deleteCommentAction(ActionRequest request, ActionResponse response, String id) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        NuxeoDocumentContext documentContext = nuxeoController.getCurrentDocumentContext();
        INuxeoCommentsService commentsService = nuxeoController.getNuxeoCommentsService();
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        Document document = documentContext.getDocument();
        try {
            commentsService.deleteDocumentComment(cmsContext, document, id);
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public boolean serveResourceByCache(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        String sOriginalDate = resourceRequest.getProperty("if-modified-since");
        if (sOriginalDate == null) {
            sOriginalDate = resourceRequest.getProperty("If-Modified-Since");
        }
        if (!this.isResourceExpired(sOriginalDate, resourceResponse, resourceRequest.getParameter("refresh"))) {
            resourceResponse.setProperty("portlet.http-status-code", String.valueOf(304));
            resourceResponse.setProperty("Last-Modified", sOriginalDate);
            resourceResponse.getPortletOutputStream().close();
            return true;
        }
        return false;
    }

    protected void serveResourceException(ResourceRequest resourceRequest, ResourceResponse resourceResponse, NuxeoException e) throws PortletException, IOException {
        int httpErrorCode = 0;
        if (e.getErrorCode() == 3) {
            httpErrorCode = 404;
            String message = "Resource CMSPortlet " + resourceRequest.getParameterMap() + " not found (error 404).";
            this.logger.error((Object)message);
        } else if (e.getErrorCode() == 1) {
            httpErrorCode = 403;
        }
        if (httpErrorCode == 0) {
            throw e;
        }
        NuxeoController nuxeoController = this.createNuxeoController((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        PortalControllerContext portalCtx = new PortalControllerContext(this.getPortletContext(), (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        String errorUrl = nuxeoController.getPortalUrlFactory().getHttpErrorUrl(portalCtx, httpErrorCode);
        resourceResponse.setProperty("portlet.http-status-code", String.valueOf(302));
        resourceResponse.setProperty("Location", errorUrl);
        resourceResponse.getPortletOutputStream().close();
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        try {
            if (this.serveResourceByCache(request, response)) {
                return;
            }
            if ("link".equals(request.getParameter("type"))) {
                String id;
                NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, null, this.getPortletContext());
                Document document = nuxeoController.fetchDocument(id = request.getResourceID());
                String url = document.getString("clink:link");
                if (!StringUtils.startsWith((String)url, (String)"http")) {
                    url = "http://" + url;
                }
                response.setProperty("portlet.http-status-code", String.valueOf(302));
                response.setProperty("Location", url);
                response.getPortletOutputStream().close();
            } else if ("fancytreeLazyLoading".equals(request.getResourceID())) {
                this.serveResourceFancytreeLazyLoading(request, response);
            } else if ("editor".equals(request.getResourceID())) {
                String editorId = request.getParameter("editorId");
                this.serveResourceEditor(request, response, editorId);
            } else {
                response.setProperty("portlet.http-status-code", String.valueOf(404));
            }
        }
        catch (NuxeoException e) {
            this.serveResourceException(request, response, e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void serveResourceFancytreeLazyLoading(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        try {
            String data = this.browserService.browse(portalControllerContext);
            response.setContentType("application/json");
            PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
            printWriter.write(data);
            printWriter.close();
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
    }

    @Deprecated
    protected void serveResourceEditor(ResourceRequest request, ResourceResponse response, String editorId) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        this.editorService.serveResource(portalControllerContext, editorId);
    }

    protected NuxeoController createNuxeoController(PortletRequest portletRequest, PortletResponse portletResponse) {
        return new NuxeoController(portletRequest, portletResponse, this.getPortletContext());
    }
}

