/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.services.dao;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentAttachmentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.liveedit.OnlyofficeLiveEditHelper;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.IDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.MimeType;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.FileMimeType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;

public final class DocumentDAO
implements IDAO<Document, DocumentDTO> {
    private static final String NUXEO_DATE_REGEX = "[\\-0-9]+T[:\\.0-9]+Z";
    private static DocumentDAO instance;
    private final INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    private final Pattern datePattern = Pattern.compile("[\\-0-9]+T[:\\.0-9]+Z");
    private final Set<String> unescapedProperties = new HashSet<String>(Arrays.asList("annonce:resume", "note:note", "ttcth:message", "webp:content"));

    private DocumentDAO() {
    }

    public static DocumentDAO getInstance() {
        if (instance == null) {
            instance = new DocumentDAO();
        }
        return instance;
    }

    @Override
    public DocumentDTO toDTO(Document document) {
        return this.toDTO((PortalControllerContext)null, document);
    }

    @Override
    public DocumentDTO toDTO(PortalControllerContext portalControllerContext, Document document) {
        DocumentDTO dto = new DocumentDTO();
        dto.setId(document.getId());
        dto.setTitle(StringEscapeUtils.escapeHtml((String)document.getTitle()));
        dto.setPath(document.getPath());
        DocumentType type = this.getType(document.getType());
        dto.setType(type);
        if (type != null) {
            String icon = type.isFile() ? StringUtils.defaultIfEmpty((String)this.getIcon(document), (String)type.getIcon()) : type.getIcon();
            dto.setIcon(icon);
        }
        dto.setLiveEditable(this.isLiveEditable(document));
        Map<String, Object> properties = dto.getProperties();
        properties.putAll(this.toMap(document.getProperties()));
        dto.setDocument(document);
        if (portalControllerContext != null) {
            this.generateAttachments(portalControllerContext, document, dto);
        }
        return dto;
    }

    private List<Object> toList(PropertyList propertyList) {
        ArrayList<Object> list = new ArrayList<Object>(propertyList.size());
        int index = 0;
        for (Object object : propertyList.list()) {
            if (object instanceof PropertyMap) {
                PropertyMap propertyMapValue = (PropertyMap)object;
                list.add(this.toMap(propertyMapValue));
            } else if (object instanceof PropertyList) {
                PropertyList propertyListValue = (PropertyList)object;
                list.add(this.toList(propertyListValue));
            } else if (object instanceof String) {
                String stringValue = (String)object;
                Matcher dateMatcher = this.datePattern.matcher(stringValue);
                if (dateMatcher.matches()) {
                    Date date = propertyList.getDate(index);
                    list.add(date);
                } else {
                    list.add(stringValue);
                }
            } else {
                list.add(object);
            }
            ++index;
        }
        return list;
    }

    private Map<String, Object> toMap(PropertyMap propertyMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(propertyMap.size());
        for (Map.Entry entry : propertyMap.map().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof PropertyMap) {
                PropertyMap propertyMapValue = (PropertyMap)value;
                map.put(key, this.toMap(propertyMapValue));
                continue;
            }
            if (value instanceof PropertyList) {
                PropertyList propertyListValue = (PropertyList)value;
                map.put(key, this.toList(propertyListValue));
                continue;
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                Matcher dateMatcher = this.datePattern.matcher(stringValue);
                if (dateMatcher.matches()) {
                    Date date = propertyMap.getDate(key);
                    map.put(key, date);
                    continue;
                }
                if (this.unescapedProperties.contains(key)) {
                    map.put(key, stringValue);
                    continue;
                }
                stringValue = StringEscapeUtils.escapeHtml((String)stringValue);
                map.put(key, stringValue);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    private DocumentType getType(String type) {
        INuxeoCustomizer cmsCustomizer = this.nuxeoService.getCMSCustomizer();
        Map<String, DocumentType> types = cmsCustomizer.getDocumentTypes();
        return types.get(type);
    }

    private boolean isLiveEditable(Document document) {
        boolean isPluginRegistered;
        String mimeType;
        PropertyMap properties = document.getProperties();
        PropertyMap fileContent = properties.getMap("file:content");
        if (fileContent != null && StringUtils.isNotBlank((String)(mimeType = fileContent.getString("mime-type"))) && (isPluginRegistered = this.nuxeoService.getCMSCustomizer().getCustomizationService().isPluginRegistered("onlyoffice.plugin"))) {
            return OnlyofficeLiveEditHelper.isMimeTypeSupported(mimeType);
        }
        return false;
    }

    private String getIcon(Document document) {
        String icon;
        PropertyMap properties = document.getProperties();
        PropertyMap fileContent = properties.getMap("file:content");
        if (fileContent == null) {
            icon = null;
        } else {
            String mimeType = fileContent.getString("mime-type");
            icon = this.getIcon(mimeType);
        }
        return icon;
    }

    public String getIcon(String mimeType) {
        FileMimeType fileMimeType;
        INuxeoCustomizer customizer = this.nuxeoService.getCMSCustomizer();
        try {
            fileMimeType = customizer.getFileMimeType(mimeType);
        }
        catch (IOException e) {
            fileMimeType = null;
        }
        String icon = fileMimeType == null ? null : fileMimeType.getIcon();
        return icon;
    }

    public String getIcon(MimeType mimeType) {
        String icon = mimeType == null ? null : this.getIcon(mimeType.getBaseType());
        return icon;
    }

    private void generateAttachments(PortalControllerContext portalControllerContext, Document document, DocumentDTO documentDto) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setCurrentDoc(document);
        String path = document.getPath();
        List<DocumentAttachmentDTO> attachments = documentDto.getAttachments();
        PropertyList list = document.getProperties().getList("files:files");
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                PropertyMap map = list.getMap(i);
                DocumentAttachmentDTO attachment = new DocumentAttachmentDTO();
                PropertyMap file = map.getMap("file");
                if (file == null) continue;
                String name = file.getString("name");
                if (StringUtils.isEmpty((String)name)) {
                    name = map.getString("filename");
                }
                attachment.setName(name);
                String mimeType = file.getString("mime-type");
                String icon = this.getIcon(mimeType);
                attachment.setIcon(icon);
                Long size = file.getLong("length");
                attachment.setSize(size);
                String digest = file.getString("digest");
                attachment.setDigest(digest);
                String url = nuxeoController.createAttachedFileLink(path, String.valueOf(i));
                attachment.setUrl(url);
                attachments.add(attachment);
            }
        }
    }
}

