/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jrobin.core.ArcDef;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdToolkit;
import org.jrobin.inspector.EditArchiveDialog;
import org.jrobin.inspector.EditDatasourceDialog;
import org.jrobin.inspector.GraphFrame;
import org.jrobin.inspector.InspectorModel;
import org.jrobin.inspector.RrdNode;
import org.jrobin.inspector.Util;

public class RrdInspector
extends JFrame {
    private static final long serialVersionUID = 1L;
    static final boolean SHOULD_CREATE_BACKUPS = true;
    static final String TITLE = "RRD File Inspector";
    static final boolean SHOULD_FIX_ARCHIVED_VALUES = false;
    static final Dimension MAIN_TREE_SIZE = new Dimension(250, 400);
    static final Dimension INFO_PANE_SIZE = new Dimension(450, 400);
    static final String ABOUT = "JRobinLite project\nRrdInspector utility\nCopyright (C) 2003-2005 Sasa Markovic. All rights reserved.";
    JTabbedPane tabbedPane = new JTabbedPane();
    private JTree mainTree = new JTree();
    private JTable generalTable = new JTable();
    private JTable datasourceTable = new JTable();
    private JTable archiveTable = new JTable();
    private JTable dataTable = new JTable();
    private InspectorModel inspectorModel = new InspectorModel();
    private String lastDirectory = null;

    private RrdInspector(String string) {
        super(TITLE);
        this.constructUI();
        this.pack();
        Util.placeWindow(this);
        this.setVisible(true);
        if (string == null) {
            this.selectFile();
        } else {
            this.loadFile(new File(string));
        }
    }

    private void constructUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.mainTree);
        jPanel2.add(jScrollPane);
        jPanel2.setPreferredSize(MAIN_TREE_SIZE);
        jPanel.add((Component)jPanel2, "West");
        this.mainTree.getSelectionModel().setSelectionMode(1);
        this.mainTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                RrdInspector.this.nodeChangedAction();
            }
        });
        this.mainTree.setModel(this.inspectorModel.getMainTreeModel());
        JScrollPane jScrollPane2 = new JScrollPane(this.generalTable);
        jScrollPane2.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("General info", jScrollPane2);
        this.generalTable.setModel(this.inspectorModel.getGeneralTableModel());
        this.generalTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.generalTable.getColumnModel().getColumn(0).setMaxWidth(150);
        JScrollPane jScrollPane3 = new JScrollPane(this.datasourceTable);
        jScrollPane3.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("Datasource info", jScrollPane3);
        this.datasourceTable.setModel(this.inspectorModel.getDatasourceTableModel());
        this.datasourceTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.datasourceTable.getColumnModel().getColumn(0).setMaxWidth(150);
        JScrollPane jScrollPane4 = new JScrollPane(this.archiveTable);
        this.archiveTable.setModel(this.inspectorModel.getArchiveTableModel());
        this.archiveTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.archiveTable.getColumnModel().getColumn(0).setMaxWidth(150);
        jScrollPane4.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("Archive info", jScrollPane4);
        JScrollPane jScrollPane5 = new JScrollPane(this.dataTable);
        this.dataTable.setModel(this.inspectorModel.getDataTableModel());
        this.dataTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.dataTable.getColumnModel().getColumn(0).setMaxWidth(100);
        this.dataTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.dataTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;
            {
                this.setBackground(Color.YELLOW);
            }
        });
        jScrollPane5.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("Archive data", jScrollPane5);
        jPanel.add((Component)this.tabbedPane, "Center");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Open RRD file...", 79);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.selectFile();
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Open RRD file in new window...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new RrdInspector(null);
            }
        });
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Add datasource...");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.addDatasource();
            }
        });
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Edit datasource...");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.editDatasource();
            }
        });
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Remove datasource");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.removeDatasource();
            }
        });
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem("Add archive...");
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.addArchive();
            }
        });
        jMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("Edit archive...");
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.editArchive();
            }
        });
        jMenu.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Remove archive...");
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.removeArchive();
            }
        });
        jMenu.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem("Plot archive values...");
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.plotArchive();
            }
        });
        jMenu.add(jMenuItem9);
        jMenu.addSeparator();
        JMenuItem jMenuItem10 = new JMenuItem("Exit", 88);
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem10);
        JMenu jMenu2 = new JMenu("Help");
        jMenu.setMnemonic(72);
        JMenuItem jMenuItem11 = new JMenuItem("About...");
        jMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.about();
            }
        });
        jMenu2.add(jMenuItem11);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RrdInspector.this.closeWindow();
            }
        });
    }

    private void closeWindow() {
        Util.dismissWindow(this);
    }

    private void about() {
        JOptionPane.showMessageDialog(this, ABOUT, "About", 1);
    }

    private void nodeChangedAction() {
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode != null) {
            this.inspectorModel.selectModel(rrdNode.getDsIndex(), rrdNode.getArcIndex());
            if (rrdNode.getDsIndex() >= 0 && rrdNode.getArcIndex() >= 0) {
                if (this.tabbedPane.getSelectedIndex() < 2) {
                    this.tabbedPane.setSelectedIndex(2);
                }
            } else if (rrdNode.getDsIndex() >= 0) {
                this.tabbedPane.setSelectedIndex(1);
            } else {
                this.tabbedPane.setSelectedIndex(0);
            }
        }
    }

    private RrdNode getSelectedRrdNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        TreePath treePath = this.mainTree.getSelectionPath();
        if (treePath != null && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof RrdNode) {
            return (RrdNode)object;
        }
        return null;
    }

    private void selectFile() {
        File file;
        JFileChooser jFileChooser = new JFileChooser(this.lastDirectory);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                String string = file.getAbsolutePath().toLowerCase();
                return file.isDirectory() || string.endsWith(".rrd") || string.endsWith(".jrb") || string.endsWith(".jrobin");
            }

            public String getDescription() {
                return "JRobin RRD files (*.rrd;*.jrb;*.jrobin)";
            }
        };
        jFileChooser.setFileFilter(fileFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.lastDirectory = file.getParent();
            this.loadFile(file);
        }
    }

    private void loadFile(File file) {
        this.inspectorModel.setFile(file);
        this.tabbedPane.setSelectedIndex(0);
    }

    private void addDatasource() {
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        DsDef dsDef = new EditDatasourceDialog((Frame)this, null).getDsDef();
        if (dsDef != null) {
            try {
                String string = this.inspectorModel.getFile().getCanonicalPath();
                RrdToolkit.addDatasource(string, dsDef, true);
                this.inspectorModel.refresh();
                this.tabbedPane.setSelectedIndex(0);
            }
            catch (IOException iOException) {
                Util.error((Component)this, iOException);
            }
            catch (RrdException rrdException) {
                Util.error((Component)this, rrdException);
            }
        }
    }

    private void addArchive() {
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        ArcDef arcDef = new EditArchiveDialog((Frame)this, null).getArcDef();
        if (arcDef != null) {
            try {
                String string = this.inspectorModel.getFile().getCanonicalPath();
                RrdToolkit.addArchive(string, arcDef, true);
                this.inspectorModel.refresh();
                this.tabbedPane.setSelectedIndex(0);
            }
            catch (IOException iOException) {
                Util.error((Component)this, iOException);
            }
            catch (RrdException rrdException) {
                Util.error((Component)this, rrdException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editDatasource() {
        int n;
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode == null || (n = rrdNode.getDsIndex()) < 0) {
            Util.error((Component)this, "Select datasource first");
            return;
        }
        try {
            String string = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrdDb = new RrdDb(string, true);
            try {
                DsDef dsDef = rrdDb.getRrdDef().getDsDefs()[n];
                rrdDb.close();
                DsDef dsDef2 = new EditDatasourceDialog((Frame)this, dsDef).getDsDef();
                if (dsDef2 != null) {
                    RrdToolkit.setDsHeartbeat(string, dsDef2.getDsName(), dsDef2.getHeartbeat());
                    RrdToolkit.setDsMinMaxValue(string, dsDef2.getDsName(), dsDef2.getMinValue(), dsDef2.getMaxValue(), false);
                    this.inspectorModel.refresh();
                    this.tabbedPane.setSelectedIndex(0);
                }
            }
            finally {
                rrdDb.close();
            }
        }
        catch (IOException iOException) {
            Util.error((Component)this, iOException);
        }
        catch (RrdException rrdException) {
            Util.error((Component)this, rrdException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editArchive() {
        int n;
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode == null || (n = rrdNode.getArcIndex()) < 0) {
            Util.error((Component)this, "Select archive first");
            return;
        }
        try {
            String string = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrdDb = new RrdDb(string, true);
            try {
                ArcDef arcDef = rrdDb.getRrdDef().getArcDefs()[n];
                rrdDb.close();
                ArcDef arcDef2 = new EditArchiveDialog((Frame)this, arcDef).getArcDef();
                if (arcDef2 != null) {
                    RrdToolkit.setArcXff(string, arcDef2.getConsolFun(), arcDef2.getSteps(), arcDef2.getXff());
                    RrdToolkit.resizeArchive(string, arcDef2.getConsolFun(), arcDef2.getSteps(), arcDef2.getRows(), true);
                    this.inspectorModel.refresh();
                    this.tabbedPane.setSelectedIndex(0);
                }
            }
            finally {
                rrdDb.close();
            }
        }
        catch (IOException iOException) {
            Util.error((Component)this, iOException);
        }
        catch (RrdException rrdException) {
            Util.error((Component)this, rrdException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDatasource() {
        int n;
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode == null || (n = rrdNode.getDsIndex()) < 0) {
            Util.error((Component)this, "Select datasource first");
            return;
        }
        try {
            String string;
            String string2 = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrdDb = new RrdDb(string2, true);
            try {
                string = rrdDb.getRrdDef().getDsDefs()[n].getDsName();
            }
            finally {
                rrdDb.close();
            }
            RrdToolkit.removeDatasource(string2, string, true);
            this.inspectorModel.refresh();
            this.tabbedPane.setSelectedIndex(0);
        }
        catch (IOException iOException) {
            Util.error((Component)this, iOException);
        }
        catch (RrdException rrdException) {
            Util.error((Component)this, rrdException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeArchive() {
        int n;
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode == null || (n = rrdNode.getArcIndex()) < 0) {
            Util.error((Component)this, "Select archive first");
            return;
        }
        try {
            int n2;
            String string;
            String string2 = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrdDb = new RrdDb(string2, true);
            try {
                ArcDef arcDef = rrdDb.getRrdDef().getArcDefs()[n];
                string = arcDef.getConsolFun();
                n2 = arcDef.getSteps();
            }
            finally {
                rrdDb.close();
            }
            RrdToolkit.removeArchive(string2, string, n2, true);
            this.inspectorModel.refresh();
            this.tabbedPane.setSelectedIndex(0);
        }
        catch (IOException iOException) {
            Util.error((Component)this, iOException);
        }
        catch (RrdException rrdException) {
            Util.error((Component)this, rrdException);
        }
    }

    private void plotArchive() {
        int n;
        if (!this.inspectorModel.isOk()) {
            Util.error((Component)this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode == null || (n = rrdNode.getArcIndex()) < 0) {
            Util.error((Component)this, "Select archive first");
            return;
        }
        String string = this.inspectorModel.getFile().getAbsolutePath();
        int n2 = rrdNode.getDsIndex();
        new GraphFrame(string, n2, n);
    }

    private static void printUsageAndExit() {
        System.err.println("usage: " + RrdInspector.class.getName() + " [<filename>]");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 1) {
            RrdInspector.printUsageAndExit();
        }
        String string = stringArray.length == 1 ? stringArray[0] : null;
        new RrdInspector(string);
    }
}

