/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.security.metadata;

import java.util.HashSet;
import java.util.Set;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.SecurityConstants;
import org.w3c.dom.Element;

public class SecurityConstraintsMetaData {
    private Set children = new HashSet();

    public Set getConstraints() {
        return this.children;
    }

    public static SecurityConstraintsMetaData buildSecurityConstraintMetaData(Element securityConstraintElt) {
        SecurityConstraintsMetaData securityConstraint = new SecurityConstraintsMetaData();
        for (Element policyPermissionElt : XMLTools.getChildren((Element)securityConstraintElt, (String)"policy-permission")) {
            Element uncheckedElt = XMLTools.getUniqueChild((Element)policyPermissionElt, (String)"unchecked", (boolean)false);
            HashSet<String> actionNames = new HashSet<String>();
            for (Element actionNameElt : XMLTools.getChildren((Element)policyPermissionElt, (String)"action-name")) {
                String actionName = XMLTools.asString((Element)actionNameElt);
                actionNames.add(actionName);
            }
            if (uncheckedElt != null) {
                RoleSecurityBinding binding = new RoleSecurityBinding(actionNames, SecurityConstants.UNCHECKED_ROLE_NAME);
                securityConstraint.children.add(binding);
                continue;
            }
            for (Element roleNameElt : XMLTools.getChildren((Element)policyPermissionElt, (String)"role-name")) {
                String roleName = XMLTools.asString((Element)roleNameElt);
                RoleSecurityBinding binding = new RoleSecurityBinding(actionNames, roleName);
                securityConstraint.children.add(binding);
            }
        }
        return securityConstraint;
    }
}

