/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.tag;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.logging.Logger;
import org.jboss.portal.theme.PortalTheme;
import org.jboss.portal.theme.ThemeElement;
import org.jboss.portal.theme.ThemeLink;
import org.jboss.portal.theme.ThemeScript;
import org.jboss.portal.theme.render.RendererContext;
import org.jboss.portal.theme.render.ThemeContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.theming.IPageHeaderResourceService;

public class ThemeTagHandler
extends org.jboss.portal.theme.tag.ThemeTagHandler {
    private static final String RESOURCE_SCRIPT = "script";
    private static final String RESOURCE_LINK = "link";
    private static Logger log = Logger.getLogger(ThemeTagHandler.class);
    private String themeName;
    private String resourceType;
    IPageHeaderResourceService pageHeaderResourceService;

    IPageHeaderResourceService getPageHeaderResourceService() {
        if (this.pageHeaderResourceService == null) {
            this.pageHeaderResourceService = (IPageHeaderResourceService)Locator.findMBean(IPageHeaderResourceService.class, (String)"osivia:service=PageHeaderResourceService");
        }
        return this.pageHeaderResourceService;
    }

    public void originalDoTag() throws JspException, IOException {
        JspWriter out = this.getJspContext().getOut();
        PageContext app = (PageContext)this.getJspContext();
        HttpServletRequest request = (HttpServletRequest)app.getRequest();
        RendererContext rendererContext = (RendererContext)request.getAttribute("RENDERCONTEXT");
        ThemeContext themeContext = rendererContext.getThemeContext();
        PortalTheme theme = themeContext.getTheme();
        if (theme == null && this.themeName != null && this.themeName.length() > 0) {
            theme = themeContext.getTheme(this.getThemeName());
        }
        if (theme != null) {
            for (ThemeElement el : theme.getElements()) {
                boolean includeElement = StringUtils.isEmpty((String)this.resourceType) ? true : (RESOURCE_LINK.equals(this.resourceType) && el instanceof ThemeLink ? true : RESOURCE_SCRIPT.equals(this.resourceType) && el instanceof ThemeScript);
                if (!includeElement) continue;
                String element = this.getPageHeaderResourceService().adaptResourceElement(el.getElement());
                out.println(element.toString());
            }
        }
    }

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        Boolean layoutParsing = (Boolean)request.getAttribute("osivia.layout.parsing");
        if (BooleanUtils.isNotTrue((Boolean)layoutParsing)) {
            this.originalDoTag();
        }
    }

    public String getThemeName() {
        return this.themeName;
    }

    public void setThemeName(String name) {
        this.themeName = name;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }
}

