/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum FileBrowserView {
    LINES("lines", "glyphicons glyphicons-show-thumbnails-with-lines", true, false, true, new String[0]),
    THUMBNAILS("thumbnails", "glyphicons glyphicons-show-thumbnails", false, true, true, "thumbnails-reorganization"),
    THUMBNAILS_REORGANIZATION("thumbnails-reorganization", null, true, false, false, "thumbnails");

    public static final FileBrowserView DEFAULT;
    private final String name;
    private final String icon;
    private final boolean orderable;
    private final boolean closedNavigation;
    private final boolean menubarItem;
    private final List<String> linkedViewNames;

    private FileBrowserView(String name, String icon, boolean orderable, boolean closedNavigation, boolean menubarItem, String ... linkedViewNames) {
        this.name = name;
        this.icon = icon;
        this.orderable = orderable;
        this.closedNavigation = closedNavigation;
        this.menubarItem = menubarItem;
        this.linkedViewNames = new ArrayList<String>(Arrays.asList(linkedViewNames));
    }

    public static final FileBrowserView fromName(String name) {
        FileBrowserView result = DEFAULT;
        if (name != null) {
            for (FileBrowserView view : FileBrowserView.values()) {
                if (!name.equals(view.name)) continue;
                result = view;
                break;
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isOrderable() {
        return this.orderable;
    }

    public boolean isClosedNavigation() {
        return this.closedNavigation;
    }

    public boolean isMenubarItem() {
        return this.menubarItem;
    }

    public List<String> getLinkedViewNames() {
        return this.linkedViewNames;
    }

    static {
        DEFAULT = LINES;
    }
}

