/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.forms;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterExecutor;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoServiceFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.portlet.model.UploadedFile;

public class FormFilterContext {
    private PortalControllerContext portalControllerContext;
    private Map<String, String> variables;
    private Map<String, Map<String, String>> filtersParams;
    private Map<String, UploadedFile> uploadedFiles;
    private String modelWebId;
    private String procedureInstanceUuid;
    private String actionId;
    private String procedureInitiator;
    private String taskInitiator;
    private String startDate;
    private String lastModified;
    private String nextStep;
    private String currentStep;
    private final Set<String> actors;
    private final Set<String> additionalAuthorizations;
    private final IFormsService formsService;

    public FormFilterContext(Map<String, Map<String, String>> filtersParams, String procedureInitiator, String taskInitiator, String startDate, String lastModified, String nextStep, String currentStep) {
        this.filtersParams = filtersParams;
        this.procedureInitiator = procedureInitiator;
        this.startDate = startDate;
        this.lastModified = lastModified;
        this.nextStep = nextStep;
        this.currentStep = currentStep;
        this.taskInitiator = taskInitiator;
        this.actors = new HashSet<String>();
        this.additionalAuthorizations = new HashSet<String>();
        this.formsService = NuxeoServiceFactory.getFormsService();
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public Map<String, UploadedFile> getUploadedFiles() {
        return this.uploadedFiles;
    }

    public void setUploadedFiles(Map<String, UploadedFile> uploadedFiles) {
        this.uploadedFiles = uploadedFiles;
    }

    public String getModelWebId() {
        return this.modelWebId;
    }

    public void setModelWebId(String modelWebId) {
        this.modelWebId = modelWebId;
    }

    public String getProcedureInstanceUuid() {
        return this.procedureInstanceUuid;
    }

    public void setProcedureInstanceUuid(String procedureInstanceUuid) {
        this.procedureInstanceUuid = procedureInstanceUuid;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getParamValue(FormFilterExecutor executor, String paramKey) {
        Map<String, String> paramsMap = this.filtersParams.get(executor.getCurrentFilterInstanceId());
        if (paramsMap != null) {
            String filterParameters = paramsMap.get(paramKey);
            try {
                HashMap<String, String> variables = new HashMap<String, String>(this.getVariables());
                variables.put("procedureInitiator", this.procedureInitiator);
                variables.put("taskInitiator", this.taskInitiator);
                variables.put("procedureStartDate", this.startDate);
                variables.put("procedureLastModified", this.lastModified);
                variables.put("currentStep", this.currentStep);
                return this.formsService.transform(this.portalControllerContext, filterParameters, variables);
            }
            catch (PortalException e) {
                throw new NuxeoException(e);
            }
        }
        return null;
    }

    public PortalControllerContext getPortalControllerContext() {
        return this.portalControllerContext;
    }

    public void setPortalControllerContext(PortalControllerContext portalControllerContext) {
        this.portalControllerContext = portalControllerContext;
    }

    public Map<String, Map<String, String>> getFiltersParams() {
        return this.filtersParams;
    }

    public String getProcedureInitiator() {
        return this.procedureInitiator;
    }

    public String getNextStep() {
        return this.nextStep;
    }

    public void setNextStep(String nextStep) {
        this.nextStep = nextStep;
    }

    public Set<String> getActors() {
        return this.actors;
    }

    public Set<String> getAdditionalAuthorizations() {
        return this.additionalAuthorizations;
    }

    public String getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(String currentStep) {
        this.currentStep = currentStep;
    }
}

