/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.deployment.jboss;

import java.net.URL;
import javax.management.MBeanServer;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.jboss.Deployment;
import org.jboss.portal.server.deployment.jboss.DeploymentFactoryContext;

public class DeploymentContext {
    private static final Logger log = Logger.getLogger(DeploymentContext.class);
    private final DeploymentFactoryContext factoryCtx;
    private final URL url;
    private Deployment deployment;
    private String name;
    private PortalWebApp pwa;
    private MBeanServer server;

    public DeploymentContext(DeploymentFactoryContext factoryCtx, PortalWebApp pwa, URL url, MBeanServer server) {
        this.factoryCtx = factoryCtx;
        this.pwa = pwa;
        this.url = url;
        this.server = server;
    }

    public URL getURL() {
        return this.url;
    }

    public DeploymentFactoryContext getFactoryContext() {
        return this.factoryCtx;
    }

    public void create() throws DeploymentException {
        log.debug((Object)("Instantiating deployment for url " + this.url + " by factory " + this.factoryCtx.getName()));
        this.deployment = this.factoryCtx.getFactory().newInstance(this.url, this.pwa, this.server);
        this.name = Tools.getShortNameOf(this.deployment.getClass());
        log.debug((Object)("Create step for deployment " + this.name + " for url " + this.url));
        this.deployment.create();
    }

    public void start() throws DeploymentException {
        if (this.deployment == null) {
            log.debug((Object)("Cannot start deployment of factory " + this.factoryCtx.getName() + " for url " + this.url + " because it is null"));
        } else {
            log.debug((Object)("Start step for deployment " + this.name + " for url " + this.url));
            this.deployment.start();
        }
    }

    public void stop() throws DeploymentException {
        if (this.deployment == null) {
            log.debug((Object)("Cannot stop deployment of factory " + this.factoryCtx.getName() + " for url " + this.url + " because it is null"));
        } else {
            log.debug((Object)("Stop step for deployment " + this.name + " for url " + this.url));
            this.deployment.stop();
        }
    }

    public void destroy() throws DeploymentException {
        if (this.deployment == null) {
            log.debug((Object)("Cannot destroy deployment of factory " + this.factoryCtx.getName() + " for url " + this.url + " because it is null"));
        } else {
            log.debug((Object)("Destroy step for deployment " + this.name + " for url " + this.url));
            this.deployment.destroy();
        }
    }
}

