/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.deployment.jboss;

import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.portal.common.net.URLNavigator;
import org.jboss.portal.common.net.URLVisitor;
import org.jboss.portal.common.util.SetMap;
import org.jboss.portal.server.deployment.jboss.DeploymentContext;
import org.jboss.portal.server.deployment.jboss.DeploymentFactoryContext;
import org.jboss.portal.server.deployment.jboss.PortalDeploymentInfo;

public class PortalDeploymentInfoContext {
    private static final Logger log = Logger.getLogger(PortalDeploymentInfoContext.class);
    private final PortalDeploymentInfo pdi;
    private final SetMap deployments;

    public PortalDeploymentInfoContext(PortalDeploymentInfo pdi) {
        this.pdi = pdi;
        this.deployments = new SetMap();
    }

    public PortalDeploymentInfo getInfo() {
        return this.pdi;
    }

    public void add(DeploymentFactoryContext factoryCtx, boolean proceedLifcycle) throws DeploymentException {
        try {
            FactoryVisitor visitor = new FactoryVisitor(factoryCtx);
            URLNavigator.visit((URL)this.pdi.url, (URLVisitor)visitor);
            for (DeploymentContext ctx : visitor.ctxs) {
                this.deployments.put((Object)ctx.getURL(), (Object)ctx);
                if (!proceedLifcycle) continue;
                try {
                    ctx.create();
                    ctx.start();
                }
                catch (DeploymentException e) {
                    log.error((Object)("Failed to deploy url " + this.pdi.url));
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void remove(DeploymentFactoryContext factoryContext, boolean proceedLifecycle) {
        for (URL childURL : new HashSet(this.deployments.keySet())) {
            Iterator j = this.deployments.iterator((Object)childURL);
            while (j.hasNext()) {
                DeploymentContext deploymentContext = (DeploymentContext)j.next();
                if (!deploymentContext.getFactoryContext().getName().equals(factoryContext.getName())) continue;
                j.remove();
                if (!proceedLifecycle) continue;
                try {
                    deploymentContext.stop();
                    deploymentContext.destroy();
                }
                catch (DeploymentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void create() throws DeploymentException {
        TreeSet<URL> sortedDeploymentKeys = new TreeSet<URL>(new URLComparator());
        sortedDeploymentKeys.addAll(this.deployments.keySet());
        for (URL url : sortedDeploymentKeys) {
            Iterator j = this.deployments.iterator((Object)url);
            while (j.hasNext()) {
                DeploymentContext ctx = (DeploymentContext)j.next();
                ctx.create();
            }
        }
    }

    public void start() throws DeploymentException {
        TreeSet<URL> sortedDeploymentKeys = new TreeSet<URL>(new URLComparator());
        sortedDeploymentKeys.addAll(this.deployments.keySet());
        for (URL url : sortedDeploymentKeys) {
            Iterator j = this.deployments.iterator((Object)url);
            while (j.hasNext()) {
                DeploymentContext ctx = (DeploymentContext)j.next();
                ctx.start();
            }
        }
    }

    public void stop() throws DeploymentException {
        TreeSet<URL> sortedDeploymentKeys = new TreeSet<URL>(new OppositeURLComparator());
        sortedDeploymentKeys.addAll(this.deployments.keySet());
        for (URL url : sortedDeploymentKeys) {
            Iterator j = this.deployments.iterator((Object)url);
            while (j.hasNext()) {
                DeploymentContext ctx = (DeploymentContext)j.next();
                ctx.stop();
            }
        }
    }

    public void destroy() throws DeploymentException {
        TreeSet<URL> sortedDeploymentKeys = new TreeSet<URL>(new OppositeURLComparator());
        sortedDeploymentKeys.addAll(this.deployments.keySet());
        for (URL url : sortedDeploymentKeys) {
            Iterator j = this.deployments.iterator((Object)url);
            while (j.hasNext()) {
                DeploymentContext ctx = (DeploymentContext)j.next();
                ctx.destroy();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OppositeURLComparator
    implements Comparator<URL> {
        private OppositeURLComparator() {
        }

        @Override
        public int compare(URL o1, URL o2) {
            return -o1.getPath().compareTo(o2.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class URLComparator
    implements Comparator<URL> {
        private URLComparator() {
        }

        @Override
        public int compare(URL o1, URL o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    }

    private class FactoryVisitor
    implements URLVisitor {
        private final Set ctxs;
        private final LinkedList acceptStack;
        private final DeploymentFactoryContext factoryCtx;

        public FactoryVisitor(DeploymentFactoryContext factoryCtx) {
            this.factoryCtx = factoryCtx;
            this.acceptStack = new LinkedList();
            this.ctxs = new HashSet();
        }

        public void startDir(URL url, String name) {
            log.debug((Object)("Trying factory " + this.factoryCtx.getName() + " to accept dir " + url));
            boolean accepted = this.factoryCtx.getFilter().acceptDir(url);
            if (accepted) {
                log.debug((Object)("Factory " + this.factoryCtx.getName() + " accepted dir " + url));
            } else {
                log.debug((Object)("Factory " + this.factoryCtx.getName() + " did not accept dir " + url));
            }
            this.acceptStack.addLast(accepted);
        }

        public void endDir(URL url, String name) {
            this.acceptStack.removeLast();
        }

        public void file(URL url, String name) {
            Boolean accepted = Boolean.TRUE;
            if (this.acceptStack.size() > 0) {
                accepted = (Boolean)this.acceptStack.getLast();
            }
            if (accepted.booleanValue()) {
                log.debug((Object)("Trying factory " + this.factoryCtx.getName() + " to accept file " + url));
                if (this.factoryCtx.getFilter().acceptFile(url)) {
                    log.debug((Object)("Factory " + this.factoryCtx.getName() + " accepted file " + url));
                    DeploymentContext ctx = new DeploymentContext(this.factoryCtx, ((PortalDeploymentInfoContext)PortalDeploymentInfoContext.this).pdi.pwa, url, PortalDeploymentInfoContext.this.pdi.getServer());
                    this.ctxs.add(ctx);
                }
            }
        }
    }
}

