/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.servlet;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CommandFilter
implements Filter {
    private static final Logger log = Logger.getLogger(CommandFilter.class);

    public void init(FilterConfig cfg) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        Object cmd = req.getAttribute("org.jboss.portal.portlet.servlet.FilterCommand");
        if (cmd != null) {
            try {
                req.removeAttribute("org.jboss.portal.portlet.servlet.FilterCommand");
                Method methods = cmd.getClass().getMethod("execute", HttpServletRequest.class, HttpServletResponse.class, FilterChain.class);
                methods.invoke(cmd, req, resp, chain);
            }
            catch (NoSuchMethodException e) {
                throw new ServletException("No execute method found on the filter command", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable wrappee = e.getTargetException();
                log.error((Object)"Exception in command invocation", wrappee);
                if (wrappee instanceof ServletException) {
                    ServletException se = (ServletException)wrappee;
                    if (se.getCause() == null && se.getRootCause() != null) {
                        se.initCause(se.getRootCause());
                    }
                    throw (ServletException)wrappee;
                }
                if (wrappee instanceof IOException) {
                    throw (IOException)wrappee;
                }
                if (wrappee instanceof RuntimeException) {
                    throw (RuntimeException)wrappee;
                }
                if (wrappee instanceof Error) {
                    throw (Error)wrappee;
                }
                ServletException se = new ServletException("The invoked command threw an exception", wrappee);
                se.initCause(wrappee);
                throw se;
            }
            catch (IllegalAccessException e) {
                ServletException se = new ServletException("Unexpected IllegalAccessException during command invocation", (Throwable)e);
                se.initCause((Throwable)e);
                throw se;
            }
        } else {
            chain.doFilter(req, resp);
        }
    }

    public void destroy() {
    }
}

