/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.servlet;

import org.jboss.portal.server.servlet.PathMapping;
import org.jboss.portal.server.servlet.PathMappingResult;

public class PathParser {
    public PathMappingResult map(PathMapping mapping, String path) throws IllegalArgumentException {
        if (mapping == null) {
            throw new IllegalArgumentException("No null mapping allowed");
        }
        if (path == null) {
            throw new IllegalArgumentException("No null request path allowed");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("No empty request path allowed");
        }
        Object target = mapping.getRoot();
        if (target == null) {
            return new PathMappingResult(target, null, path);
        }
        if ("/".equals(path)) {
            return new PathMappingResult(target, "", "/");
        }
        int previousSlashPos = 0;
        StringBuffer matchedPath = new StringBuffer();
        while (true) {
            Object o;
            String atom;
            int nextSlashPos;
            if ((nextSlashPos = path.indexOf(47, previousSlashPos + 1)) == -1) {
                atom = path.substring(previousSlashPos + 1);
                o = mapping.getChild(target, atom);
                if (o != null) {
                    target = o;
                    matchedPath.append('/').append(atom);
                    String remainingPath = "";
                    return new PathMappingResult(target, matchedPath.toString(), remainingPath);
                }
                String remainingPath = "/" + atom;
                return new PathMappingResult(target, matchedPath.toString(), remainingPath);
            }
            if (nextSlashPos == previousSlashPos + 1) {
                previousSlashPos = nextSlashPos;
                continue;
            }
            atom = path.substring(previousSlashPos + 1, nextSlashPos);
            o = mapping.getChild(target, atom);
            if (o == null) break;
            target = o;
            matchedPath.append('/').append(atom);
            previousSlashPos = nextSlashPos;
        }
        String remainingPath = path.substring(previousSlashPos);
        return new PathMappingResult(target, matchedPath.toString(), remainingPath);
    }
}

